# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::Widget::Abrowse;

use Glib qw(TRUE FALSE);
use Gtk2;

use base qw(Gtk2::TreeView);

use Arch::Session;

use constant MODEL_COL_COUNT  => 4;
use constant MODEL_COL_TYPES  => qw(Glib::String Glib::String Glib::String Glib::String);
use constant MODEL_COL_TITLES  => qw(Name Details HideDetails Path); 
use constant MODEL_COL_NAME    => 0;
use constant MODEL_COL_DETAILS => 1;
use constant MODEL_COL_HIDE    => 2;
use constant MODEL_COL_PATH    => 3;

sub new ($$) {
	my $class = shift;
	my $limit = shift;

	my $self = bless Gtk2::TreeView->new(), $class;
	$self->set_model(Gtk2::TreeStore->new(MODEL_COL_TYPES));

	$self->_init();
	$self->show($limit) if ($limit);

	return $self;
}

sub _init ($) {
	my $self = shift;

	for my $col (MODEL_COL_NAME, MODEL_COL_DETAILS) {
		my $column = Gtk2::TreeViewColumn->new_with_attributes(
			(MODEL_COL_TITLES)[$col], Gtk2::CellRendererText->new(),
			text => $col,
		);
		$column->set_resizable(TRUE);

		$self->append_column($column);
	}

	$self->set_rules_hint(TRUE);
}

sub get_selected_path ($) {
	my $self = shift;

	my $iter = $self->get_selection()->get_selected();
	return $iter ? $self->get_model()->get($iter, MODEL_COL_PATH) : undef;
}

sub select_by_path ($$) {
	my $self = shift;
	my $path = shift;

	my $model = $self->get_model();
	my $iter  = $model->get_iter_first();
	while (defined $iter) {
		my $ipath = $model->get($iter, MODEL_COL_PATH);

		if ($ipath eq $path) {
			$self->expand_to_path($self->get_model->get_path($iter));
			$self->get_selection()->select_iter($iter);
			last;
		} elsif (substr($path, 0, length($ipath)+2) eq "$ipath--") {
			$iter = $model->iter_children($iter);
		} else {
			$iter = $model->iter_next($iter);
		}
	}
}

sub show ($$) {
	my $self  = shift;
	my $limit = shift;

	my $model = $self->get_model();
	$model->clear();

	return unless (defined $limit);

	my $session = Arch::Session->new;
	$session->working_name($limit);
	my $abrowse = $session->expanded_archive_info;
	tree_model_append($model, undef, ($session->working_names)[0] . '/', @$abrowse);

	$self->select_by_path($limit);

# 	$self->expand_all();
# 	$self->get_selection()->select_iter($top);
}

sub tree_model_append ($$@) {
	my ($model, $parent, $path_prefix, @items) = @_;

	foreach my $item (@items) {
		my $name    = $item->[0];
		my $hide    = ref($item->[1]) eq 'ARRAY';
		my $details = $hide ? '' : ($item->[1] . ($item->[2] ? "..$item->[2]" : ""));
		my $path    = $path_prefix . $name;

		my $iter = $model->append($parent);
		$model->set($iter,
			MODEL_COL_NAME,    $name,
			MODEL_COL_DETAILS, $details,
			MODEL_COL_HIDE,    $hide,
			MODEL_COL_PATH,    $path,
		);

		&tree_model_append($model, $iter, $path . '--', @{$item->[1]})
			if $hide;
	}
}

1;

__END__
