# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::Widget::Diff;

use Glib qw(TRUE FALSE);
use Gtk2;
use Gtk2::Pango;

use base qw(Gtk2::TextView);

my %TAG_COLORS = (
	new   => '#b0b0b0',
	old   => '#b0b0b0',
	lines => '#f0f0a0',
	add   => '#90f090',
	del   => '#f09090',
	mod   => '#f0f090',
);

sub new ($) {
	my $class = shift;

	my $self = bless Gtk2::TextView->new(), $class;

	$self->_init();

	return $self;
}

sub _init ($) {
	my $self = shift;

	$self->set_editable(FALSE);
	$self->set_cursor_visible(FALSE);
	$self->set_wrap_mode('none');

	my $fd = Gtk2::Pango::FontDescription->new();
	$fd->set_family('monospace');
	$self->modify_font($fd);

	my $buffer = $self->get_buffer();

	foreach my $tag (keys %TAG_COLORS) {
		$buffer->create_tag($tag, background => $TAG_COLORS{$tag});
	}
}

sub set_tag ($$@) {
	my $self = shift;
	my ($tag, @props) = @_;

	my $table = $self->get_buffer()->get_tag_table();
	my $texttag = $table->lookup($tag);
	$table->remove($texttag);
	$self->get_buffer()->create_tag($tag, @props);
}

sub clear ($) {
	my $self = shift;

	$self->get_buffer->set_text('');
}

sub show ($$) {
	my $self = shift;
	my $diff = shift;

	$self->clear;

	my $buffer = $self->get_buffer;
	my $iter = $buffer->get_iter_at_offset(0);
	foreach my $line (split /\n/, $diff) {
		my $tag = undef;
		if ($line =~ /^\+\+\+/) {
			$tag = 'new';

		} elsif ($line =~ /^---/) {
			$tag = 'old';

		} elsif ($line =~ /^@@/) {
			$tag = 'lines';

		} elsif ($line =~ /^\+/) {
			$tag = 'add';

		} elsif ($line =~ /^-/) {
			$tag = 'del';

		} elsif ($line =~ /^!/) {
			$tag = 'mod';
		}

		if (defined $tag) {
			$buffer->insert_with_tags_by_name($iter, $line, $tag);
		} else {
			$buffer->insert($iter, $line);
		}

		$buffer->insert($iter, "\n");
	}
}

1;

__END__
