// -*- c++ -*-
//  Generated by gtkmmproc from ./../clist.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_CLIST_H
#define _GTKMM_CLIST_H

/* $Id: clist.h,v 1.3 2005/06/09 18:14:22 taybin Exp $ */

/* clist.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/**********************************************************************
WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
***********************************************************************
  This wrapper is new to the kit.  The old one was so out of date
  as to not be useful.  This wrapper has not been time tested
  like the others, please be sure to report unexpected crashes, strange
  behavior and unusable methods.
***********************************************************************
WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
**********************************************************************/
/* the following things are broken and not fixable until
  next binary version.  row__ and number__ should be mutable.
  The non-const versions of get_row and get_number should
  be removed.  All the things taking a row iterator really
  should just take a row or row iterator.  push_front and
  push_back need to return iterators for autosort case.
*/

#include <gtk--/container.h>
#include <gtk/gtkclist.h>

namespace Gtk {
class CList;
class CList_Class;
}
namespace Gtk { Gtk::CList *wrap (GtkCList *o); }
extern "C" void gtkmm_clist_click_column(GtkCList*,gint p0);
extern "C" void gtk_clist_set_scroll_adjustments(GtkCList*,GtkAdjustment* p1,GtkAdjustment* p2);
namespace Gtk
{

class CList;
namespace CList_Helpers {

class Freeze
  {
    CList *clist_;
    public:
      Freeze(CList& clist);
      ~Freeze();
  };

/*********************************************************************/
class Row;
class CellIterator;
class Cell
  {
    protected:
      friend class Gtk::CList;
      friend class Row;

      GtkCList    *parent_;
      GtkCListRow *row__;
      gint         number__;
      gint         column_;

      GtkCell* get_cell();
      GtkCell* get_cell() const;
      GtkCListRow* get_row();
      GtkCListRow* get_row() const;
      gint get_row_num();
      gint get_row_num() const;

      Cell(GtkCList *,GtkCListRow *,gint);
      Cell(GtkCList *,gint,gint);
      Cell();

      void redraw();

    public:
      GtkCellType get_type() const;
      Gtk::Style* get_style() const;
      nstring get_text() const;
      guint8 get_spacing() const;
      Gdk_Pixmap get_pixmap() const;
      Gdk_Bitmap get_mask() const;

      //: Removes all cell contents
      void clear();

      //: Sets the style of the cell
      void set_style(Gtk::Style&);

      //: Sets the spacing between pixmap and text.
      void set_spacing(guint8);

      //: Sets the text of the cell
      void set_text(nstring);

      //: Sets the pixmap of the cell
      void set_pixmap(const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask=0);

      void set_shift(gint vertical,gint horizontal);

      void select();
      void unselect();
      void moveto(gfloat row_align=0.5,gfloat col_align=0.5);

  };

class CellIterator: private Cell
  {
    private:
      friend class Row;
      CellIterator(GtkCList* parent, GtkCListRow* row, gint column)
        : Cell(parent,row,column)
        {}

    public:
      CellIterator()
        : Cell()
        {}

      typedef bidirectional_iterator_tag iterator_category;
      typedef size_t size_type;
      typedef ptrdiff_t difference_type;

      typedef Cell  value_type;
      typedef Cell* pointer;
      typedef Cell& reference;
      typedef CellIterator Self;

      Self&  operator++();
      Self&  operator--();
      Self   operator++(int) {Self t=*this; Self::operator++(); return t;}
      Self   operator--(int) {Self t=*this; Self::operator--(); return t;}

      reference operator*()  const;
      pointer operator -> () const;

      bool operator ==(const Self& cell) const {return column_==cell.column_;}
      bool operator !=(const Self& cell) const {return column_!=cell.column_;}
  };

/*********************************************************************/

// Types
class ColumnVector;
class ColumnIterator;
class Column
  {
    protected:
      friend class ColumnVector;
      GtkCList* parent_;
      gint column_;

      Column(GtkCList* parent,gint number);
      Column();

    public:

      void set_active();
      void set_passive();

      void set_title(const string& title);
      string get_title();

      void set_widget(Gtk::Widget* widget=0);
      void set_widget(Gtk::Widget& widget);
      Gtk::Widget* get_widget();
      void set_justification(GtkJustification);
      void set_visiblity(bool);
      void set_resizable(bool);
      void set_auto_resize(bool);
      gint get_optimal_width();

      void set_width(gint);
      void set_min_width(gint);
      void set_max_width(gint);
      void moveto(gfloat row_align=0.5,gfloat col_align=0.5);
  };

class SelectionList;
class RowList;
class RowIterator;
class Row
  {
    public:
      typedef Cell                               value_type;
      typedef value_type &                       reference;
      typedef const value_type &                 const_reference;

      typedef CellIterator                       iterator;
      typedef G_List_ConstIterator<iterator>     const_iterator;
      typedef G_List_ReverseIterator<iterator>   reverse_iterator;
      typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

      typedef size_t                             difference_type;
      typedef size_t                             size_type;

    protected:
      friend class SelectionList;
      friend class RowList;

      GtkCList*    parent_;
      GtkCListRow* row__;    // cache of row node   (0 if not set)
      gint         number__; // cache of row number (-1 if not set)

      GtkCListRow* get_row();
      GtkCListRow* get_row() const;

      Row(GtkCList*,GtkCListRow*);
      Row(GtkCList*,gint);
      Row();

      iterator begin_() const
        { return iterator(parent_,get_row(),0); }
      iterator end_() const
        { return iterator(parent_,get_row(),parent_->columns); }

      Row& operator = (const Row& r)
        { parent_=r.parent_; row__=r.row__; number__=r.number__; return *this; }

    public:
      Row(const Row& r)
        : parent_(r.parent_), row__(r.row__), number__(r.number__)
        {}

      ~Row() {}

      gint get_row_num();
      gint get_row_num() const;

      GtkVisibility is_visible();

      Gtk::Style* get_style() const;
      gpointer get_data() const;
      bool get_selectable() const;
      void moveto(gfloat row_align=0.5,gfloat col_align=0.5);

      void set_style(Gtk::Style&);
      void set_data(gpointer);
      void set_data(gpointer,GtkDestroyNotify);
      void set_selectable(bool selectable);
      void set_foreground(const Gdk_Color& color);
      void set_background(const Gdk_Color& color);

      void focus();
      void select(gint column=-1);
      void unselect(gint column=-1);

      // we want the row to look like a pointer for consistancy
      Row& operator *()              { return *this; }
      const Row& operator *() const  { return *this; }
      Row* operator ->()             { return this; }
      const Row* operator ->() const { return this; }


      /*** Cell Vector operations ***/

      iterator begin()
        {return begin_();}
      iterator end()
        {return end_();}

      const_iterator begin() const
        { return const_iterator(begin_()); }
      const_iterator end() const
        { return const_iterator(end_()); }

      reverse_iterator rbegin()
        { return reverse_iterator(end_()); }
      reverse_iterator rend()
        { return reverse_iterator(begin_()); }

      const_reverse_iterator rbegin() const
        { return const_reverse_iterator(reverse_iterator(end_())); }
      const_reverse_iterator rend() const
        { return const_reverse_iterator(reverse_iterator(begin_())); }

      size_type size(void) const
        { return size_type(parent_->columns); }
      size_type max_size(void)
        { return size_type(parent_->columns); }
      bool empty(void)
        { return false; }

      value_type operator[](size_type l) const
        { return Cell(parent_, get_row(), l); }

  };


// Iterators
class ColumnIterator: private Column
  {
    private:
      friend class ColumnVector;
      ColumnIterator(GtkCList* parent,gint number)
        : Column(parent,number)
        {}

    public:
      ColumnIterator()
        : Column()
        {}

      typedef bidirectional_iterator_tag iterator_category;
      typedef size_t size_type;
      typedef ptrdiff_t difference_type;

      typedef Column  value_type;
      typedef Column* pointer;
      typedef Column& reference;
      typedef ColumnIterator Self;

      Self&  operator++();
      Self&  operator--();
      Self   operator++(int) {Self t=*this; Self::operator++(); return t;}
      Self   operator--(int) {Self t=*this; Self::operator--(); return t;}

      reference operator*() const;
      pointer operator -> () const;

      bool operator ==(const Self& col) const {return column_==col.column_;}
      bool operator !=(const Self& col) const {return column_!=col.column_;}

  };

class RowIterator: protected Row
  {
    protected:
      friend class RowList;
      GList* node_;

      RowIterator(GtkCList*,GList*);
      RowIterator(GtkCList*,gint);
    public:

      typedef bidirectional_iterator_tag iterator_category;
      typedef size_t size_type;
      typedef ptrdiff_t difference_type;

      typedef Row  value_type;
      typedef Row* pointer;
      typedef Row& reference;

      typedef RowIterator Self;

      RowIterator();
      RowIterator(const Self& s)
        : Row(s), node_(s.node_) {}

      Self& operator= (const Self& s)
        { Row::operator=(s); node_=s.node_; return *this; }

      Self&  operator++();
      Self&  operator--();
      Self   operator++(int) {Self t=*this; Self::operator++(); return t;}
      Self   operator--(int) {Self t=*this; Self::operator--(); return t;}

      reference operator*()  const;
      pointer operator -> () const;

      bool operator ==(const Self& row) const {return node_==row.node_;}
      bool operator !=(const Self& row) const {return node_!=row.node_;}

    protected:
      GList* get_node() const;
      GtkCListRow* get_row() const;
      gint get_row_num() const;
  };

class SelectionIterator: protected Row
  {
    private:
      friend class SelectionList;
      GList* node_;

      SelectionIterator(GtkCList* parent,GList* node)
        : Row(parent,0), node_(node)
        {}

    public:
      typedef bidirectional_iterator_tag iterator_category;
      typedef size_t size_type;
      typedef ptrdiff_t difference_type;

      typedef Row  value_type;
      typedef Row* pointer;
      typedef Row& reference;

      typedef SelectionIterator Self;

      SelectionIterator()
        {}

      SelectionIterator(const Self& s)
        : Row(s), node_(s.node_) {}

      Self& operator= (const Self& s)
        { Row::operator=(s); node_=s.node_; return *this; }

      reference operator*()  const;
      pointer operator -> () const;

      Self&  operator++();
      Self&  operator--();
      Self   operator++(int) {Self t=*this; Self::operator++(); return t;}
      Self   operator--(int) {Self t=*this; Self::operator--(); return t;}

      bool operator ==(const Self& row) const {return node_==row.node_;}
      bool operator !=(const Self& row) const {return node_!=row.node_;}
  };

// Containers

class ColumnVector
  {
    public:
      typedef Column                             value_type;
      typedef value_type &                       reference;
      typedef const value_type &                 const_reference;

      typedef ColumnIterator                     iterator;
      typedef G_List_ConstIterator<iterator>     const_iterator;
      typedef G_List_ReverseIterator<iterator>   reverse_iterator;
      typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

      typedef size_t                             difference_type;
      typedef size_t                             size_type;

    private:
      friend class CList;
      Gtk::CList *parent_; // this will be shared with the other lists.

      iterator begin_() const;
      iterator end_() const;

    public:

      iterator begin()
        {return begin_();}
      iterator end()
        {return end_();}

      const_iterator begin() const
        { return const_iterator(begin_()); }
      const_iterator end() const
        { return const_iterator(end_()); }

      reverse_iterator rbegin()
        { return reverse_iterator(end_()); }
      reverse_iterator rend()
        { return reverse_iterator(begin_()); }

      const_reverse_iterator rbegin() const
        { return const_reverse_iterator(reverse_iterator(end_())); }
      const_reverse_iterator rend() const
        { return const_reverse_iterator(reverse_iterator(begin_())); }

      value_type front() const     { return *begin(); }
      value_type back() const      { return *(--end()); }

      value_type operator[](size_type l) const;

      size_type size(void) const;
      size_type max_size(void) const;
      bool empty(void)
        { return false; }

      // This has not insert, erase, remove, or clear methods
      // It is not changable

  };

class SelectionList
  {
    public:
      typedef Row                                value_type;
      typedef value_type &                       reference;
      typedef const value_type &                 const_reference;

      typedef SelectionIterator                  iterator;
      typedef G_List_ConstIterator<iterator>     const_iterator;
      typedef G_List_ReverseIterator<iterator>   reverse_iterator;
      typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

      typedef size_t                             difference_type;
      typedef size_t                             size_type;

    private:
      friend class CList;
      Gtk::CList *parent_; // this will be shared with the other lists.

      iterator begin_() const;
      iterator end_() const;

      GList*& glist() const;

    public:
      iterator begin()
        {return begin_();}
      iterator end()
        {return end_();}

      const_iterator begin() const
        { return const_iterator(begin_()); }
      const_iterator end() const
        { return const_iterator(end_()); }

      reverse_iterator rbegin()
        { return reverse_iterator(end_()); }
      reverse_iterator rend()
        { return reverse_iterator(begin_()); }

      const_reverse_iterator rbegin() const
        { return const_reverse_iterator(reverse_iterator(end_())); }
      const_reverse_iterator rend() const
        { return const_reverse_iterator(reverse_iterator(begin_())); }

      value_type front() const     { return *begin(); }
      value_type back() const      { return *(--end()); }

      // This is order n. (use at own risk)
      value_type operator[](size_type l) const;

      size_type size(void) const;
      size_type max_size(void) const { return size_type(-1); }
      bool empty(void) { return glist() == 0; }

      void all();
      void clear();
      void undo();

      // this has no insert method, items can only be removed
  };

class RowList
  {
    public:
      typedef Row                                value_type;
      typedef value_type &                       reference;
      typedef const value_type &                 const_reference;

      typedef RowIterator                        iterator;
      typedef G_List_ConstIterator<iterator>     const_iterator;
      typedef G_List_ReverseIterator<iterator>   reverse_iterator;
      typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

      typedef size_t                             difference_type;
      typedef size_t                             size_type;

    private:
      friend class CList;
      Gtk::CList * parent_; // this will be shared with the other lists.

      iterator begin_() const;
      iterator end_() const;

      GList*& glist() const;

    public:
      iterator begin()
        {return begin_();}
      iterator end()
        {return end_();}

      const_iterator begin() const
        { return const_iterator(begin_()); }
      const_iterator end() const
        { return const_iterator(end_()); }

      reverse_iterator rbegin()
        { return reverse_iterator(end_()); }
      reverse_iterator rend()
        { return reverse_iterator(begin_()); }

      const_reverse_iterator rbegin() const
        { return const_reverse_iterator(reverse_iterator(end_())); }
      const_reverse_iterator rend() const
        { return const_reverse_iterator(reverse_iterator(begin_())); }

      value_type front() const     { return *begin(); }
      value_type back() const      { return *(--end()); }

      // This is order n. (use at own risk)
      value_type operator[](size_type l) const;

      size_type size(void) const;
      size_type max_size(void) const { return size_type(-1); }
      bool empty(void) { return glist() == 0; }

      iterator insert(iterator position, const Gtk::SArray& e);
      iterator insert(const_reference position, const Gtk::SArray& e);

      void push_front(const Gtk::SArray& e);
      void push_back(const Gtk::SArray& e);
      void pop_front()                  { erase(begin()); }
      void pop_back()                   { erase(--end()); }

      void clear();

      iterator erase(iterator);
      void erase(iterator start, iterator stop);
      void remove(const_reference);

      void swap(iterator, iterator);
      void move(iterator, iterator);
      void swap(const_reference, const_reference);
      void move(const_reference, const_reference);

      // returns end if no rows have the specified data.
      // FIXME this is not the right solution to the problem
      // as it doesn't handle cases of multiple data.
      iterator find_data(gpointer);
  };
}


class Adjustment;
class Style;

//: A multi-columned scrolling list widget.
//- The GtkCList widget is a very useful multi-columned scrolling list. It can
//- display data in nicely aligned vertical columns, with titles at the top of the list.
class CList : public Container
{

public:
  typedef CList          CppObjectType;
  typedef CList_Class    CppClassType;
  typedef GtkCList           BaseObjectType;
  typedef GtkCListClass      BaseClassType;

private:
  friend class CList_Class;
  static CppClassType clist_class;

  CList(const CList&);
  CList& operator=(const CList&); // not implemented

protected:
  void   initialize_class();
  explicit CList(GtkCList *castitem);

public:
  static GtkType get_type();
  GtkCList* gtkobj()             { return (GtkCList*)(gtkobject); }
  const GtkCList* gtkobj() const { return (GtkCList*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~CList();

private:

public:
  // import our helper names
  typedef Gtk::CList_Helpers::Freeze Freeze;

  typedef Gtk::CList_Helpers::Cell Cell;
  typedef Gtk::CList_Helpers::CellIterator CellIterator;

  typedef Gtk::CList_Helpers::Column Column;
  typedef Gtk::CList_Helpers::ColumnVector ColumnVector;

  typedef Gtk::CList_Helpers::Row Row;
  typedef Gtk::CList_Helpers::RowIterator RowIterator;
  typedef Gtk::CList_Helpers::RowList RowList;

  typedef Gtk::CList_Helpers::SelectionIterator  SelectionIterator ;
  typedef Gtk::CList_Helpers::SelectionList SelectionList;


  CList(int columns, const gchar * titles[] = 0);
  CList(const SArray &titles);


/* Adjustment functions */


  //: Set adjustments of clist.


  void set_hadjustment(Gtk::Adjustment* adjustment=0);


  void set_vadjustment(Gtk::Adjustment* adjustment=0);


  void set_hadjustment(Gtk::Adjustment& adjustment);


  void set_vadjustment(Gtk::Adjustment& adjustment);

  //: Get adjustments of clist.
  Gtk::Adjustment* get_hadjustment() const;

  Gtk::Adjustment* get_vadjustment() const;



/* global clist changes */

  //: Set the border style of the clist, valid choices are:
  //- {\enum GTK_SHADOW_NONE}, {\enum GTK_SHADOW_IN},
  //- {\enum GTK_SHADOW_OUT}, {\enum GTK_SHADOW_ETCHED_IN}, or
  //- {\enum GTK_SHADOW_ETCHED_OUT}.


  void set_shadow_type(GtkShadowType type);

  //: Set the clist's selection mode.
  //- mode can be one of: {\enum GTK_SELECTION_SINGLE},
  //- {\enum GTK_SELECTION_BROWSE}, or {\enum GTK_SELECTION_MULTIPLE},
  //- {\enum GTK_SELECTION_EXTENDED}.


  void set_selection_mode(GtkSelectionMode mode);


  GtkSelectionMode get_selection_mode() const;

  //: Enable clists reorder ability.


  void set_reorderable(bool reorderable);


  void set_use_drag_icons(bool use_icons);


  void set_button_actions(guint button,guint8 button_actions);

  //: Freeze all visual updates of the list.
  //- Thaw the list after you
  //- have made a number of changes and the updates will occur in a more
  //- efficient manner than if you made them on an unfrozen list.


  void freeze();

  //: Thaw the list (see also {freeze}).


  void thaw();

  //: Show the column title buttons.


  void column_titles_show();

  //: Hide the column title buttons.


  void column_titles_hide();

  //: Set all column titles to be a active.
  //- The column titles will respond to button presses, prelight, and grab keyboard focus.


  void column_titles_active();

  //: Set all column titles to be passive.
  //- Passive titles act as just a title and do not respond to
  //- focus and button presses.


  void column_titles_passive();



  gint columns_autosize();

  //: Change the height of the rows.
  //- The default is the height of the current font.


  void set_row_height(guint height);


  gint get_row_height() const;



/********************** Sort operations **************************/

  //: Sets a compare function different to the default.


  void set_compare_func(GtkCListCompareFunc cmp_func);

  //: The column to sort by.


  void set_sort_column(gint column);

  //: How to sort : ascending or descending.


  void set_sort_type(GtkSortType sort_type);

  //: Sort the list with the current compare function.


  void sort();

  //: Automatically sort upon insertion.


  void set_auto_sort(bool auto_sort);


/********************** Resource **************************/
  RowList& rows()
    {
      return reinterpret_cast<RowList&>(clist_self);
      //pointer to ref cast works because
      //Gtk::CList* parent_ is only member data of RowList.
      //TODO: Add a RowList constructor instead.
    }
  const RowList& rows() const
    {
      return reinterpret_cast<const RowList&>(clist_self);
      //pointer to ref cast works because
      //Gtk::CList* parent_ is only member data of RowList.
      //TODO: Add a RowList constructor instead.
    }
  Row row(int r) { return rows()[r]; }
  const Row row(int r) const { return rows()[r]; }

  SelectionList& selection()
    {
      return reinterpret_cast<SelectionList&>(clist_self);
      //pointer to ref cast works because
      //Gtk::CList* parent_ is only member data of SelectionList.
      //TODO: Add a SelectionList constructor instead.
    }
  const SelectionList& selection() const
    {
      return reinterpret_cast<const SelectionList&>(clist_self);
      //pointer to ref cast works because
      //Gtk::CList* parent_ is only member data of SelectionList.
      //TODO: Add a SelectionList constructor instead.
    }

  ColumnVector& columns()
    {
      return reinterpret_cast<ColumnVector&>(clist_self);
      //pointer to ref cast works because
      //Gtk::CList* parent_ is only member data of ColumnVector.
      //TODO: Add a ColumnVector constructor instead.
    }
  const ColumnVector& columns() const
    {
      return reinterpret_cast<const ColumnVector&>(clist_self);
      //pointer to ref cast works because
      //Gtk::CList* parent_ is only member data of ColumnVector.
      //TODO: Add a ColumnVector constructor instead.
    }
  Column column(int c) { return columns()[c]; }
  const Column column(int c) const { return columns()[c]; }

  Cell cell(gint row, gint column);
  const Cell cell(gint row, gint column) const;

/********************** Selection operations **************************/

  //: Select a row.
  //- obsolete: Use clist.row(row).select().

 //: Unselect a row.
 //- obsolete: Use clist.row(row).unselect().

  //: Return the row column corresponding to the x and y coordinates.
  //- <P> reference and pointer style available.



  gint get_selection_info(gint x,gint y,gint* row,gint* column) const;

  //: Select all rows.
  //- This method only works in multi or extended mode.
  //-
  //- obsolete: Use clist.selection().all().



  //- obsolete: Use clist.selection().clear().



  //: Undo the last select/unselect operation.
  //- obsolete: Use clist.selection().undo().



/********************** Col operations **************************/

  //: Set a column title to be activate.
  //- The column responds to button presses, prelights, and grabs keyboard focus.
  //-
  //- obsolete: Use clist.column(column).set_active().


  void column_title_active(gint column);

  //: Set a column title to be passive.
  //- obsolete: Use clist.column(column).set_passive().


  void column_title_passive(gint column);

  //: Set the title in the column title button.
  //- obsolete: Use clist.column(column).set_title(title).


  void set_column_title(gint column,const string& title);

  //: Returns the title of column. Returns an empty string if title is not set.
  //- obsolete: Use clist.column(column).get_title().


  string get_column_title(gint column) const;

  //: Set a widget instead of a title for the column title button.
  //- obsolete: Use clist.column(column).set_widget(widgth).


  void set_column_widget(gint column,Gtk::Widget& widget);

  //: Returns the column widget.
  //- obsolete: Use clist.column(column).get_widget().


  Gtk::Widget* get_column_widget(gint column) const;


  //: Set the justification on a column.
  //- valid choices are:
  //- {\enum GTK_JUSTIFY_LEFT}, {\enum GTK_JUSTIFY_RIGHT},
  //- {\enum GTK_JUSTIFY_CENTER}, or{\enum GTK_JUSTIFY_FILL}.
  //-
  //- obsolete: Use clist.column(column).set_justification(justify).


  void set_column_justification(gint column,GtkJustification justification);

  //: Set visibility of a column.
  //- obsolete: Use clist.column(column).set_visiblity(on).


  void set_column_visibility(gint column,bool visible);

  //: Enable/disable column resize operations by mouse.
  //- obsolete: Use clist.column(column).set_resizable(on).


  void set_column_resizeable(gint column,bool resizeable);

  //: Resize column automatically to its optimal width.
  //- obsolete: Use clist.column(column).set_auto_resize(on).


  void set_column_auto_resize(gint column,bool auto_resize);

  //: Return the optimal column width, i.e. maximum of all cell widths.
  //- obsolete: Use clist.column(column).get_optimal_width().


  gint optimal_column_width(gint column) const;

  //: Set the pixel width of a column.
  //- This is a necessary step in
  //- creating a CList because otherwise the column width is chozen from
  //- the width of the column title, which will never be right.
  //-
  //- obsolete: Use clist.column(column).set_width(width).


  void set_column_width(gint column,gint width);

  //: Returns the width in pixels of the column, returns -1 if the column doens't exist. Column numbers start with 0.
  //- obsolete: Use clist.column(column).get_width().
  gint get_column_width(gint column) const;

  //: Set column minimum width. min_width < 0 => no restriction.
  //- obsolete: Use clist.column(column).set_min_width(min).


  void set_column_min_width(gint column,gint min_width);

  //: Set column maximum width. max_width < 0 => no restriction.
  //- obsolete: Use clist.column(column).set_max_width(max).


  void set_column_max_width(gint column,gint max_width);

  //: Represents a button click on a column title.


/********************** Row List operations **************************/
  //: Prepend a row (see also insert_row).
  //- note: Method is named prepend in gtk+.
  //-
  //- obsolete: Use clist.rows().push_front(text).


  gint prepend_row(const SArray& text);


  gint prepend(const SArray& text);

  //: Append a row (see also insert_row).
  //- note: Method is named append in gtk+.
  //-
  //- obsolete: Use clist.rows().push_back(text).


  gint append_row(const SArray& text);


  gint append(const SArray& text);

  //: Inserts a row at index row.
  //- note: Method is named insert in gtk+.
  //-
  //- obsolete: Use clist.rows().insert(clist.row(row),text).


  gint insert_row(gint row,const SArray& text);


  gint insert(gint row,const SArray& text);

  //: Clear the entire list.
  //- Faster than individual removal.
  //-
  //- obsolete: Use clist.rows().clear().


  void clear();

  //: Returns the number of rows.
  //- obsolete: Use clist.rows().size().
  gint get_rows() const;

  //: Swap the position of two rows.
  //- obsolete: Use clist.rows().swap(clist.row(row1),clist.row(row2)).


  void swap_rows(gint row1,gint row2);

  //: Move row from source_row position to dest_row position.
  //- obsolete: Use clist.rows().move(clist.row(row1),clist.row(row2)).


  //: Given a data pointer, find the first (and hopefully only!) row that points to that data, or -1 if none.
  //- obsolete: Use clist.rows().find_data(data).


  gint find_row_from_data(gpointer data) const;



/********************** Row operations **************************/
  //: Whether the row is visible.
  //- obsolete: Use clist.row(row).is_visible().


  GtkVisibility row_is_visible(gint row) const;

  //: Sets the foreground color of a row, the color must already be allocated.
  //- obsolete: Use clist.row(row).set_foreground(color).


  void set_foreground(gint row,const Gdk_Color& color);

  //: Sets the background color of a row, the color must already be allocated.
  //- obsolete: Use clist.row(row).set_background(color).


  void set_background(gint row,const Gdk_Color& color);

  //- obsolete: Use clist.row(row).set_style(style).


  void set_row_style(gint row,Gtk::Style& style);

  //- obsolete: Use clist.row(row).get_style().


  Gtk::Style* get_row_style(gint row) const;

  //- obsolete: Use clist.row(row).get_selectable().


  bool get_selectable(gint row) const;

  //: Set selectable flag of a single row.
  //- obsolete: Use clist.row(row).set_selectable(selectable).


  void set_selectable(gint row,bool selectable);

  //: Removes row at index row.
  //- Note: this is gtk_clist_remove() in gtk, but renamed
  //- here to remove_row().
  //-
  //- obsolete: Use clist.rows().remove(clist.row(row)).


  void remove_row(gint row);

  //: Sets a arbitrary data pointer for a given row.
  //- obsolete: Use clist.row(row).get_data().


  void set_row_data(gint row,gpointer data);

  //: Returns the data set for a row.
  //- obsolete: Use clist.row(row).set_data(data).


  gpointer get_row_data(gint row) const;

  //: Sets a data pointer for a given row with destroy notification.
  //- obsolete: Use clist.row(row).set_data(data,destroy).



  void set_row_data_full(gint row,gpointer data,GtkDestroyNotify destroy);



/********************** Cell operations *************************/
  //: Scroll the viewing area of the list to the given column and row.
  //- row_align and col_align are between 0-1 representing the
  //- location the row should appear on the screnn, 0.0 being top or left,
  //- 1.0 being bottom or right. If row or column is -1 then then there
  //- is no change.
  //-
  //- obsolete: Use clist.cell(row,column).moveto().



  void moveto(gint row,gint column,gfloat row_align=0.5,gfloat col_align=0.5);


  //: Returns the cell type.
  //- GtkCellType is one of:
  //- {\enum GTK_CELL_EMPTY}, {\enum GTK_CELL_TEXT}, {\enum GTK_CELL_PIXMAP},
  //- {\enum GTK_CELL_PIXTEXT}, or {\enum GTK_CELL_WIDGET}.
  //-
  //- obsolete: Use clist.cell(row,column).get_type().


  GtkCellType get_cell_type(gint row,gint column) const;

  //: Sets a given cell's text, replacing it's current contents.
  //-
  //- obsolete: Use clist.cell(row,column).set_text(text).


  void set_text(gint row,gint column,const string& text);

  //: Get cell's text.
  //- Returns true on success.
  //-
  //- obsolete: Use clist.cell(row,column).get_text().
  bool         get_text(gint row, gint column, nstring *text) const;
  bool         get_text(gint row, gint column, string &text) const;
  nstring get_text(gint row, gint column) const;

  //: Sets a given cell's pixmap, replacing it's current contents.
  //- obsolete: Use clist.cell(row,column).set_pixmap(pixmap,mask).



  void set_pixmap(gint row,gint column,const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask);

  //: Get cell's pixmap.
  //- obsolete: Use clist.cell(row,column).get_pixmap().
  gint get_pixmap(gint row, gint column,
                  Gdk_Pixmap &pixmap, Gdk_Bitmap &mask) const;

  //: Sets a given cell's pixmap and text, replacing it's current contents.
  //- obsolete: Full replacement of contents not needed, use cell methods.

  void set_pixtext(gint row,gint column,const string& text,guint8 spacing,const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask);

  //- Any of the return pointer can be NULL if you are not interested.
  //-
  //- text: An output not an input. If the cell is empty a zero length
  //- string ("") will be returned.
  //-
  //- obsolete: Use cell methods.
  bool get_pixtext(gint row, gint column, string& text,
                   guint8 &spacing,
                   Gdk_Pixmap &pixmap, Gdk_Bitmap &mask) const;

  //: Set cell style.
  //- obsolete: Use clist.cell(row,column).set_style(style).


  void set_cell_style(gint row,gint column,Gtk::Style& style);

  //: Get cell style.
  //- obsolete: Use clist.cell(row,column).get_style().


  Gtk::Style* get_cell_style(gint row,gint column) const;

  //: This sets a horizontal and vertical  for drawing the contents of a cell.
  //- The  can be positive or negative. This is
  //- particulary useful for indenting items in a column.
  //-
  //- obsolete: Use clist.cell(row,column).set_shift(vertical,horizontal).



  void set_shift(gint row,gint column,gint vertical,gint horizontal);



/*********************** Signals (largely internal) ****************/

/****** These are user overridable functions, NOT signals **********/

              //const Gtk_SArray&));





private:
  virtual bool check_seliterator_type() const;

public:

    class Proxy_select_row
      : public ProxySignal3<void,gint,gint,GdkEvent*,CppObjectType,BaseObjectType,0>
      {
          typedef ProxySignal3<void,gint,gint,GdkEvent*,CppObjectType,BaseObjectType,0> BaseType;
        public:
          Connection connect(const SigC::Slot3<void,gint,gint,GdkEvent*> &s);
         void operator ()(gint row, gint column=-1)
             {emit(row,column);}
         void emit(gint row, gint column=-1);

      };
    class Proxy_unselect_row
      : public ProxySignal3<void,gint,gint,GdkEvent*,CppObjectType,BaseObjectType,1>
      {
          typedef ProxySignal3<void,gint,gint,GdkEvent*,CppObjectType,BaseObjectType,1> BaseType;
        public:
          Connection connect(const SigC::Slot3<void,gint,gint,GdkEvent*> &s);
           void operator ()(gint row, gint column=-1)
             {emit(row,column);}
           void emit(gint row, gint column=-1);

      };
    class Proxy_set_scroll_adjustments
      : public Gtk::EmitProxySignal2<void,GtkAdjustment*,GtkAdjustment*,CppObjectType,BaseObjectType,16,&gtk_clist_set_scroll_adjustments>
      {
          typedef Gtk::EmitProxySignal2<void,GtkAdjustment*,GtkAdjustment*,CppObjectType,BaseObjectType,16,&gtk_clist_set_scroll_adjustments> BaseType;
        public:
          void operator ()(Gtk::Adjustment*,Gtk::Adjustment*);
          void emit(Gtk::Adjustment*,Gtk::Adjustment*);
          Connection connect(const SigC::Slot2<void,Gtk::Adjustment*,Gtk::Adjustment*> &s);
      };
  union
    {
      CppObjectType * clist_self;
      Proxy_select_row select_row;
      Proxy_unselect_row unselect_row;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,2,&gtk_clist_select_all> select_all;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,3,&gtk_clist_unselect_all> unselect_all;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,4,&gtk_clist_undo_selection> undo_selection;
      Gtk::EmitProxySignal1<void,gint,CppObjectType,BaseObjectType,5,&gtkmm_clist_click_column> click_column;
      Gtk::EmitProxySignal2<void,gint,gint,CppObjectType,BaseObjectType,6,&gtk_clist_row_move> row_move;
      Gtk::ProxySignal2<void,gint,gint,CppObjectType,BaseObjectType,7> resize_column;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,8> toggle_focus_row;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,9> toggle_add_mode;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,10> start_selection;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,11> end_selection;
      Gtk::ProxySignal3<void,GtkScrollType,gfloat,gboolean,CppObjectType,BaseObjectType,12> extend_selection;
      Gtk::ProxySignal2<void,GtkScrollType,gfloat,CppObjectType,BaseObjectType,13> scroll_vertical;
      Gtk::ProxySignal2<void,GtkScrollType,gfloat,CppObjectType,BaseObjectType,14> scroll_horizontal;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,15> abort_column_resize;
      Proxy_set_scroll_adjustments set_scroll_adjustments;
    };

protected:
  // impl functions
    virtual void select_row_impl(gint p0,gint p1,GdkEvent* p2);
    virtual void unselect_row_impl(gint p0,gint p1,GdkEvent* p2);
    virtual void select_all_impl();
    virtual void unselect_all_impl();
    virtual void undo_selection_impl();
    virtual void click_column_impl(gint p0);
    virtual void row_move_impl(gint p0,gint p1);
    virtual void resize_column_impl(gint p0,gint p1);
    virtual void toggle_focus_row_impl();
    virtual void toggle_add_mode_impl();
    virtual void start_selection_impl();
    virtual void end_selection_impl();
    virtual void extend_selection_impl(GtkScrollType p0,gfloat p1,gboolean p2);
    virtual void scroll_vertical_impl(GtkScrollType p0,gfloat p1);
    virtual void scroll_horizontal_impl(GtkScrollType p0,gfloat p1);
    virtual void abort_column_resize_impl();
    virtual void set_scroll_adjustments_impl(Gtk::Adjustment* p0,Gtk::Adjustment* p1);
    virtual int insert_row_impl(gint row,gchar** p1);
    virtual void remove_row_impl(gint row);
    virtual void clear_impl();
    virtual void sort_list_impl();

};
typedef CList ColumnList;

}

#endif
