#ifndef __ardour_gtk_automation_time_axis_h__
#define __ardour_gtk_automation_time_axis_h__

#include <vector>
#include <list>
#include <string>
#include <ardour/types.h>

#include "time_axis_view.h"

namespace ARDOUR {
	class Session;
	class Route;
}

namespace Gtk {
	class Widget;
}

class PublicEditor;
class TimeSelection;
class AudioRegionSelection;
class PointSelection;
class AutomationLine;
class GhostRegion;

class AutomationTimeAxisView : public TimeAxisView {
  public:
	AutomationTimeAxisView (ARDOUR::Session&,
				ARDOUR::Route&,
				PublicEditor&,
				Gtk::Widget* parent,
				std::string name,
				std::string plug_name = "");

	~AutomationTimeAxisView();
	
	void set_height (TimeAxisView::TrackHeight);
	void set_samples_per_unit (double);
	std::string name() const { return _name; }

	virtual void add_automation_event (GtkCanvasItem *item, GdkEvent *event, jack_nframes_t, double) = 0;

	AutomationLine* line;

	void set_selected_points (PointSelection&);
	void get_selectables (jack_nframes_t start, jack_nframes_t end, double top, double bot, list<Selectable *>&);

	void show_timestretch (TimeSelection&) {}
	void hide_timestretch () {}

	/* editing operations */
	
	bool cut_copy_clear (Selection&, Editing::CutCopyOp);
	bool cut_copy_clear_objects (PointSelection&, Editing::CutCopyOp);
	bool paste (jack_nframes_t, float times, Selection&, size_t nth);

	void add_ghost (GhostRegion*);
	void remove_ghost (GhostRegion*);

  protected:
	ARDOUR::Route& route;
	GtkCanvasItem* base_rect;
	string _name;

	Gtk::Button        hide_button;
	Gtk::Button        height_button;
	Gtk::Button        clear_button;
	Gtk::ToggleButton  active_button; 

	void clear_clicked ();
	void height_clicked ();
	void hide_clicked ();
	void active_toggled ();

	virtual void build_display_menu ();

	list<GhostRegion*> ghosts;
};

#endif /* __ardour_gtk_automation_time_axis_h__ */
