#ifndef __gtk_ardour_editing_h__
#define __gtk_ardour_editing_h__

namespace Editing {

	enum CutCopyOp {
		Cut,
		Copy,
		Clear
	};

	enum SnapType {
		SnapToBar,
		SnapToBeat,
		SnapToFrame,
		SnapToMark,
		SnapToAThirdBeat,
		SnapToAQuarterBeat,
		SnapToAEighthBeat,
		SnapToASixteenthBeat,
		SnapToAThirtysecondBeat,
		SnapToEditCursor,
		SnapToRegionStart,
		SnapToRegionEnd,
		SnapToRegionSync,
		SnapToRegionBoundary
	};

	enum SnapMode {
		SnapNormal,
		SnapMagnetic
	};

	enum XFadeType {
		Pre,
		Post,
		At
	};

	enum RegionListSortType {
		ByName,
		ByLength,
		ByPosition,
		ByTimestamp,
		ByStartInFile,
		ByEndInFile,
		BySourceFileName,
		BySourceFileLength,
		BySourceFileCreationDate,
		BySourceFileFS
	};

	enum MouseMode {
		MouseRange,
		MouseObject,
		MouseGain,
		MouseZoom,
		MouseScrub,
		MouseTimeFX,
	};

	enum ZoomFocus {
		ZoomFocusLeft,
		ZoomFocusRight,
		ZoomFocusCenter,
		ZoomFocusPlayhead,
		ZoomFocusEdit
	};

	enum DisplayControl {
		ShowMeasures,
		ShowWaveforms,
		FollowPlayhead
	};

} // namespace Editing

#endif // __gtk_ardour_editing_h__
