/*
    Copyright (C) 2002 Paul Davis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: gain_pan_meter.h,v 1.12 2004/01/29 04:56:46 pbd Exp $
*/

#ifndef __ardour_gtk_gain_pan_meter_h__
#define __ardour_gtk_gain_pan_meter_h__

#include <vector>
#include <gtk--.h>
#include <gtkmmext/slider_controller.h>
#include <gtkmmext/click_box.h>

#include "enums.h"

class Panner;

namespace ARDOUR {
	class IO;
	class Session;
}
namespace Gtkmmext {
	class FastMeter;
}

class GainPanMeter : public Gtk::VBox
{
  public:
	GainPanMeter (ARDOUR::IO&, ARDOUR::Session&);
	~GainPanMeter ();

	void set_sensitive (bool yn);

	void update_meters ();
	void update_display () {
		update_gain_display ();
		effective_pan_display ();
	}

	void set_width (Width);
	void setup_meters ();
	void setup_pan ();

	Gtk::HBox   pan_box;
	
	void set_meter_strip_name (string name);

  private:
	ARDOUR::IO& _io;
	ARDOUR::Session& _session;

	bool ignore_toggle;

	Gtkmmext::VSliderController *gain_slider;
	Gtk::Adjustment              gain_adjustment;
	Gtk::Frame                   gain_display_frame;
	Gtkmmext::ClickBox           gain_display;
	Gtk::Frame                   peak_display_frame;
	Gtk::EventBox                peak_display;
	Gtk::Label                   peak_display_label;
	Gtk::Button                  gain_unit_button;
	Gtk::Label                   gain_unit_label;
	Gtk::HBox                    gain_display_box;
	Gtk::HBox                    fader_box;
	Gtk::DrawingArea             meter_metric_area;
	Gtk::ToggleButton            meter_pre_button;
        Gtk::Label                   meter_pre_label;
	Gtk::Table                   top_table;
	Width                       _width;

	gint meter_metrics_expose (GdkEventExpose *);

	static void _gain_printer (char buf[32], Gtk::Adjustment&, void *);
	void gain_printer (char buf[32], Gtk::Adjustment&);
	
	struct MeterInfo {
	    Gtkmmext::FastMeter *meter;
	    gint16          width;   
	    bool            packed;
	    
	    MeterInfo() { 
		    meter = 0;
		    width = 0;
		    packed = false;
	    }
	};

	static const guint16 regular_meter_width = 5;
	static const guint16 thin_meter_width = 2;
	vector<MeterInfo>    meters;
	float       max_peak;
	
	Panner*     panner;
	Gtk::Frame  pan_frame;

	Gtk::HBox   hbox;
	Gtk::HBox   meter_packer;

	void update_gain_display ();
	void gain_adjusted ();
	void gain_changed (void *);
	
	void meter_pre_toggled ();
	void meter_changed (void *);
	void gain_unit_changed ();
	
	void hide_all_meters ();
	void hide_pans ();

	void panner_moved ();
	void pan_changed (void *);
	void equal_power_stereo_pan (float val);
	float pan_value(float left, float right);
	void panner_bypass_toggled ();
	void effective_pan_display ();

	gint meter_button_press (GdkEventButton*, unsigned int);
	gint meter_button_release (GdkEventButton*, unsigned int);

	gint peak_button_release (GdkEventButton*);
	
	Gtk::Menu* meter_menu;
	void popup_meter_menu (GdkEventButton*);

	gint start_gain_touch (GdkEventButton*);
	gint end_gain_touch (GdkEventButton*);
	gint start_pan_touch (GdkEventButton*);
	gint end_pan_touch (GdkEventButton*);
};

#endif /* __ardour_gtk_gain_pan_meter_h__ */

