/*
    Copyright (C) 2000 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: plugin_ui.h,v 1.28 2004/01/26 23:24:37 pbd Exp $
*/

#ifndef __ardour_plugin_ui_h__
#define __ardour_plugin_ui_h__

#include <vector>

#include <gtk--.h>

#include <ardour_dialog.h>

namespace ARDOUR {
	class AudioEngine;
	class PluginInsert;
}

namespace LADSPA {
	class Plugin;
}

namespace Gtkmmext {
	class HSliderController;
	class ClickBox;
	class FastMeter;
}

class PluginUI : public Gtk::VBox 
{
  public:
	PluginUI (ARDOUR::AudioEngine &, ARDOUR::PluginInsert& plug, bool scrollable=false);
	~PluginUI ();
	
	gint get_preferred_height () { return prefheight; }

	gint start_updating(GdkEventAny*);
	gint stop_updating(GdkEventAny*);

  private:
	ARDOUR::AudioEngine &engine;
	ARDOUR::PluginInsert& insert;
	LADSPA::Plugin& plugin;
	Gtk::HBox settings_box;
	Gtk::HBox hpacker;
	
	Gtk::Table button_table;
	Gtk::Table output_table;

	Gtk::Combo combo;

	Gtk::Button save_btn;
	Gtk::Button load_btn;
	Gtk::ToggleButton bypass_button;
	Gtk::ScrolledWindow scroller;
	Gtk::Viewport scroller_view;
	Gtk::Label nameinfo_label;
	Gtk::Label paraminfo_label;
	Gtk::Label makerinfo_label;
		
	bool setting_name_status;

	gint prefheight;
	bool is_scrollable;

	struct MeterInfo {
		Gtkmmext::FastMeter *meter;

		LADSPA_Data     min;
		LADSPA_Data     max;
		bool            min_unbound;
		bool            max_unbound;
		bool packed;
		
		MeterInfo(int i) { 
			meter = 0;
			packed = false;
			min = 1.0e10;
			max = -1.0e10;
			min_unbound = false;
			max_unbound = false;
		}
	};
	
	static const int initial_button_rows = 6;
	static const int initial_button_cols = 1;
	static const int initial_output_rows = 8;
	static const int initial_output_cols = 1;

	struct ControlUI : public Gtk::HBox {

	    unsigned long      port_index;
	    
	    /* input */
	    
	    Gtk::Adjustment* adjustment;
	    Gtkmmext::PixmapButton*      button;
	    Gtkmmext::HSliderController* control;
	    Gtkmmext::ClickBox*          clickbox;
	    Gtk::Label         label;
	    bool               logarithmic;
	    bool               update_pending;
	    char               ignore_change;
	    Gtk::ToggleButton  automate_rec_button;
	    Gtk::ToggleButton  automate_play_button;
	    
	    /* output */

	    Gtk::EventBox *display;
	    Gtk::Label*    display_label;

	    Gtk::VBox  *    vbox;
	    MeterInfo  *    meterinfo;

	    ControlUI ();
	    ~ControlUI(); 
	};
	
	vector<ControlUI*>   output_controls;
	SigC::Connection screen_update_connection;
	void output_update();
	
	void build (ARDOUR::AudioEngine &);
	ControlUI* build_control_ui (ARDOUR::AudioEngine &, guint32 port_index, MIDI::Controllable *);
	void control_adjustment_changed (ControlUI* cui);
	void control_port_changed (unsigned long, LADSPA_Data, ControlUI* cui);
	void update_control_display (ControlUI* cui);
	void control_port_toggled (ControlUI* cui);
	void bypass_toggled();
	void setting_selected(void);
	void save_plugin_setting (void);
	gint entry_focus_event (GdkEventFocus* ev);

	void redirect_active_changed (ARDOUR::Redirect*, void*);

	void arec_toggled (ControlUI*, unsigned long port);
	void aplay_toggled (ControlUI*, unsigned long port);

};


class PluginUIWindow : public ArdourDialog
{
  public:
	PluginUIWindow (ARDOUR::AudioEngine &, ARDOUR::PluginInsert& insert, bool scrollable=false);
	~PluginUIWindow ();

	PluginUI& pluginui() { return _pluginui; }

	void resize_preferred();
	
  private:
	PluginUI _pluginui;
	void plugin_going_away (ARDOUR::Redirect*);
};

#endif /* __ardour_plugin_ui_h__ */
