/*
    Copyright (C) 2000 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: redirect_automation_line.h,v 1.13 2004/02/22 18:18:41 pauld Exp $
*/

#ifndef __ardour_gtk_redirect_automation_line_h__
#define __ardour_gtk_redirect_automation_line_h__

#include <ardour/ardour.h>
#include <gtk-canvas.h>
#include <gtk--.h>

#include "automation_line.h"

namespace ARDOUR {
	class Session;
	class Redirect;
}

class TimeAxisView;

class RedirectAutomationLine : public AutomationLine
{
  public:
	RedirectAutomationLine (string name, ARDOUR::Redirect&, unsigned long port, ARDOUR::Session&, TimeAxisView&, GtkCanvasItem* parent,
				ARDOUR::AutomationList&, 
				gint (*point_callback)(GtkCanvasItem*, GdkEvent*, gpointer),
				gint (*line_callback)(GtkCanvasItem*, GdkEvent*, gpointer));
	
	unsigned long port() const { return _port; }
	ARDOUR::Redirect& redirect() const { return _redirect; }

	string get_verbose_cursor_string (float);

  private:
	ARDOUR::Session& session;
	ARDOUR::Redirect& _redirect;
	unsigned long _port;
	float upper;
	float lower;
	float range;

	void view_to_model_y (double&);
	void model_to_view_y (double&);
	void change_model (unsigned long, double x, double y);
	void change_model_range (unsigned long, unsigned long, double delta);
};


#endif /* __ardour_gtk_region_gain_line_h__ */
