/*
    Copyright (C) 2003 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: route_automation_time_axis.cc,v 1.5 2004/02/29 23:33:55 pauld Exp $
*/

#include <ardour/curve.h>
#include <ardour/route.h>

#include "route_automation_time_axis.h"
#include "automation_line.h"

using namespace ARDOUR;
using namespace Gtk;

RouteAutomationTimeAxisView::RouteAutomationTimeAxisView (Session& s, Route& r, PublicEditor& e, Widget* p, std::string n, ARDOUR::Curve& c)

	: AxisView (s),
	  AutomationTimeAxisView (s, r, e, p, n, ""),
	  curve (c)
	
{
}

RouteAutomationTimeAxisView::~RouteAutomationTimeAxisView ()
{
}

void
RouteAutomationTimeAxisView::add_automation_event (GtkCanvasItem* item, GdkEvent* event, jack_nframes_t when, double y)
{
	double x = 0;

	gtk_canvas_item_w2i (canvas_display, &x, &y);

	/* compute vertical fractional position */

	y = 1.0 - (y / height);

	/* map using line */

	line->view_to_model_y (y);

	if (&curve == &route.gain_automation_curve()) {
		_session.begin_reversible_command ("add gain automation event");
	} else {
		_session.begin_reversible_command ("add pan automation event");
	}

	_session.add_undo (curve.get_memento());
	curve.add (when, y);
	_session.add_undo (curve.get_memento());
	_session.commit_reversible_command ();
}


