/*
    Copyright (C) 2000 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: route_params_ui.h,v 1.12 2003/08/11 04:05:23 essej Exp $
*/

#ifndef __ardour_route_params_ui_h__
#define __ardour_route_params_ui_h__

#include <list>

#include <gtk--.h>

#include <ardour/ardour.h>
#include <ardour/stateful.h>
#include <ardour/io.h>
#include <ardour/redirect.h>

#include "io_selector.h"
#include "ardour_dialog.h"
#include "keyboard_target.h"


namespace LADSPA {
	class Plugin;
}

namespace ARDOUR {
	class Route;
	class Send;
	class Insert;
	class Session;
	class PortInsert;
	class Connection;
}

class PluginManager;

class RouteParams_UI : public ArdourDialog, public KeyboardTarget
{
  public:
	RouteParams_UI (ARDOUR::AudioEngine&);
	~RouteParams_UI();

	void set_session (ARDOUR::Session *);
	void session_gone ();
	PluginManager&  plugin_manager() { return *_plugin_manager; }

  private:
	ARDOUR::AudioEngine&     engine;

	Gtk::HBox                global_hpacker;
	Gtk::VBox                global_vpacker;
	Gtk::ScrolledWindow      scroller;
	Gtk::EventBox            scroller_base;
	Gtk::HBox                scroller_hpacker;
	Gtk::VBox                mixer_scroller_vpacker;

	Gtk::VBox                list_vpacker;
	Gtk::CList               route_select_list;
	Gtk::Label               route_list_button_label;
	Gtk::Button              route_list_button;
	Gtk::ScrolledWindow      route_select_scroller;

	Gtk::Frame 		 route_select_frame;

	Gtk::HBox                route_hpacker;
	Gtk::VBox                route_vpacker;

	Gtk::HPaned		 list_hpane;

	Gtk::HPaned		 right_hpane;
	
	Gtk::Frame 		 route_choice_frame;

	Gtk::Frame 		 route_param_frame;

	Gtk::VBox                choice_vpacker;
	
	Gtk::HBox           pre_redirect_hpacker;
	Gtk::CList          pre_redirect_list;
	Gtk::ScrolledWindow pre_redirect_scroller;

	Gtk::HBox           post_redirect_hpacker;
	Gtk::CList          post_redirect_list;
	Gtk::ScrolledWindow post_redirect_scroller;

	Gtk::ToggleButton input_button;
	Gtk::ToggleButton output_button;
	Gtk::Label  track_input_label;
	
	Gtk::Label  title_label;
	
	Gtk::Container * _active_view;
	
	PluginManager    *_plugin_manager;

	ARDOUR::Route           *_route;
	SigC::Connection            _route_conn;
	SigC::Connection            _route_ds_conn;
	ARDOUR::Redirect       *_redirect;
	SigC::Connection            _plugin_conn;

	
	enum ConfigView {
		NO_CONFIG_VIEW = 0,
		INPUT_CONFIG_VIEW,
		OUTPUT_CONFIG_VIEW,
		PLUGIN_CONFIG_VIEW,		
		PORTINSERT_CONFIG_VIEW,
		SEND_CONFIG_VIEW
	};
	
	ConfigView _current_view;
	
	void add_route (ARDOUR::Route&);

	void route_name_changed (void *src, ARDOUR::Route *route);
	void route_removed (ARDOUR::Route *route);


	void route_selected (gint row, gint col, GdkEvent *ev);
	void route_unselected (gint row, gint col, GdkEvent *ev);

	void set_current_view(Gtk::Container *view, RouteParams_UI::ConfigView cfgv);
	void finish_current_view();

	void plugin_going_away (LADSPA::Plugin *foo);
	void redirect_going_away (ARDOUR::Redirect *foo);

	gint edit_input_configuration (GdkEventButton *ev);
	gint edit_output_configuration (GdkEventButton *ev);
	
	void update_routeinfo (ARDOUR::Route * route);
	
	Gtk::Menu *redirect_menu;
	void build_redirect_menu ();

	Gtk::Menu *track_menu;
	void show_track_menu(gint arg);
	
	void choose_send ();
	void choose_insert ();
	void choose_plugin ();
	void insert_plugin_chosen (LADSPA::Plugin *);
	void all_redirects_active (bool state);
	void clear_redirects();
	gint remove_redirect (ARDOUR::Redirect *);

	ARDOUR::Redirect::Placement selected_redirect_placement;

	SigC::Connection newplug_connection;
	
	gint redirect_click (GdkEventButton *, ARDOUR::Redirect::Placement);
	void redirects_changed (void *);
	void show_redirect_active (ARDOUR::Redirect *, void *);
	void add_redirect_to_display (ARDOUR::Redirect *);
	string redirect_name (ARDOUR::Redirect&);
	void show_redirect_menu (gint, ARDOUR::Redirect::Placement);

	bool redirect_drag_in_progress;
	void redirect_drag_begin (GdkDragContext*);
	void redirect_drag_end (GdkDragContext*);

	void redirects_reordered (gint, gint);
	gint compute_redirect_sort_keys ();
	
	
	void disconnect_newplug ();
	void show_plugin_selector ();

	void update_title ();
	void unselect_all_redirects ();

	SigC::Connection update_connection;
	void update_views ();

	void start_updating ();
	void stop_updating ();
};


#endif /* __ardour_route_params_ui_h__ */
