/*
    Copyright (C) 2003 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: fastmeter.h,v 1.4 2003/06/17 02:31:08 pbd Exp $
*/

#ifndef __gtkmmext_fastmeter_h__
#define __gtkmmext_fastmeter_h__

#include <gtk--/drawingarea.h>
#include <gtk--/pixmap.h>

namespace Gtkmmext {

class FastMeter : public Gtk::DrawingArea {
  public:
	enum Orientation { 
		Horizontal,
		Vertical
	};
	
	FastMeter (unsigned long hold_cnt, unsigned long width, Orientation);
	virtual ~FastMeter ();
	
	void set (float);
	void clear ();
	
	static void set_horizontal_xpm (const char **xpm);
	static void set_vertical_xpm (const char **xpm);
	
  protected:
	gint expose_event_impl (GdkEventExpose*);
	void size_request_impl (GtkRequisition*);
	
  private:  
	static GdkPixmap *h_pixmap;
	static GdkBitmap *h_mask;
	static gint h_pixheight;
	static gint h_pixwidth;

	static GdkPixmap *v_pixmap;
	static GdkBitmap *v_mask;
	static gint v_pixheight;
	static gint v_pixwidth;

	Orientation orientation;
	GdkPixmap   *backing;
	GdkRectangle pixrect;
	gint request_width;
	unsigned long hold_cnt;
	unsigned long hold_state;
	float current_level;
	float current_peak;

	gint vertical_expose (GdkEventExpose*);
	gint horizontal_expose (GdkEventExpose*);
};


} /* namespace */

 #endif /* __gtkmmext_fastmeter_h__ */
