/*
    Copyright (C) 2004 Paul Davis
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: mwc.cc,v 1.2 2004/12/16 14:59:33 taybin Exp $
*/

#include <gtkmmext/mwc.h>
#include <gtkmmext/doi.h>

#include "i18n.h"

using namespace SigC;
using namespace std;
using namespace Gtk;
using namespace Gtkmmext;

MessageWithConfirmation::MessageWithConfirmation (string msg)
	: Window (GTK_WINDOW_DIALOG),
	  ok (_("OK"))
{
	label.set_text (msg);

	vpacker.set_spacing (12);
	vpacker.pack_start (label);
	vpacker.pack_start (ok, false, false);
	
	ok.clicked.connect (slot (*this, &MessageWithConfirmation::ok_clicked));

	set_border_width (7);
	add_events (GDK_BUTTON_RELEASE_MASK|GDK_BUTTON_PRESS_MASK);
	set_position (GTK_WIN_POS_CENTER);

	add (vpacker);
	show_all ();

	delete_event.connect (slot (*this, &MessageWithConfirmation::wm_close));
	button_release_event.connect (slot (*this, &MessageWithConfirmation::button_release));

	realize ();
	get_window().set_decorations (GdkWMDecoration (GDK_DECOR_BORDER|GDK_DECOR_RESIZEH));
}

MessageWithConfirmation::~MessageWithConfirmation ()
{
	GoingAway (); /* EMIT SIGNAL */
}

void
MessageWithConfirmation::ok_clicked ()
{
	delete_when_idle (this);
}

gint 
MessageWithConfirmation::button_release (GdkEventButton* ev)
{
	delete_when_idle (this);
	return TRUE;
}

gint
MessageWithConfirmation::wm_close (GdkEventAny* ev)
{
	delete_when_idle (this);
	return TRUE;
}
