// -*- c++ -*-
//  Generated by gtkmmproc from ./../style.gen_h -- DO NOT MODIFY!
#include <gtk--/style.h>
#include <gtk--/private/style_p.h>
namespace Gtk
{

/*
Design notes:

Okay these are my notes on how a GtkStyle works.
They are not meant to be taken as documentation as I didn't
write the code.

styles keeps a copy of itself for each color depth.  Thus
changing a style after it has been attached wont work!

At allocation time a Gtk Style has
  - all GC set to 0 as they will be allocated later
  - has all color values set to default values.
  - a ref count of 1 and an attach count of 0 (floating?)
  - a properly referenced font.
  - colormap and depth are invalid.
  - The style list and rcstyle are 0. (??? styles wasn't set explicitly!)

It returns to this state if the style is detatched from
all widgets.

Attach acts to sink the object removing it from the floating state.

attaching a style for the first time initializes it.
Initializing a style
  - sets the colormap and depth.
  - sets the mid colors. (thus allowing user to set these would be pointless)
  - gets black and white from the colormap.
  - allocates all the colors.
  - uses gtk_gc_get to share a gc if there is a matching one.

Conclusions, we need to rework the concept of Gdk to allow
for const objects.

*/

Style* Style::create()
{
  return (Style*)gtk_style_new();
}

Style::~Style()
{}

Style*
Style::ref()
{
  gtk_style_ref(gtkobj());
  return this;
}

void
Style::unref()
{
  gtk_style_unref(gtkobj());
}

Style*
Style::copy() const
{
  return (Style*)(gtk_style_copy(const_cast<GtkStyle*>(gtkobj())));
}

void
Style::set_font(Gdk_Font f)
{
  g_return_if_fail ( f.gdkobj()!=0 );
  gdk_font_unref(gtkobj()->font);
  gtkobj()->font=f.gdkobj();
  gdk_font_ref(gtkobj()->font);
}

Gdk_Font
Style::get_font () const
{
  return Gdk_Font ( gtkobj() -> font );
}

void
Style::set_bg ( GtkStateType state_type, const Gdk_Color &new_color )
{
  memcpy ( &( gtkobj() -> bg [ state_type ] ), &new_color, sizeof ( GdkColor ) );
}

void
Style::set_light ( GtkStateType state_type, const Gdk_Color &new_color )
{
  memcpy ( &( gtkobj() -> light [ state_type ] ), &new_color, sizeof ( GdkColor ) );
}

void
Style::set_dark ( GtkStateType state_type, const Gdk_Color &new_color )
{
  memcpy ( &( gtkobj() -> dark [ state_type ] ), &new_color, sizeof ( GdkColor ) );
}

void
Style::set_mid ( GtkStateType state_type, const Gdk_Color &new_color )
{
  memcpy ( &( gtkobj() -> mid [ state_type ] ), &new_color, sizeof ( GdkColor ) );
}

void
Style::set_base ( GtkStateType state_type, const Gdk_Color &new_color )
{
  memcpy ( &( gtkobj() -> base [ state_type ] ), &new_color, sizeof ( GdkColor ) );
}

void
Style::set_fg ( GtkStateType state_type, const Gdk_Color &new_color )
{
  memcpy ( &( gtkobj() -> fg [ state_type ] ), &new_color, sizeof ( GdkColor ) );
}

void
Style::set_text ( GtkStateType state_type, const Gdk_Color &new_color )
{
  memcpy ( &( gtkobj() -> text [ state_type ] ), &new_color, sizeof ( GdkColor ) );
}

void
Style::set_background(const Gdk_Drawable& window, GtkStateType state_type)
{
  gtk_style_set_background(const_cast<GtkStyle*>(gtkobj()), window, state_type);
}

void
Style::draw_hline(Gdk_Window     &window,
			   GtkStateType   state_type,
			   gint           x1,
			   gint           x2,
			   gint           y) const
{
  gtk_draw_hline(const_cast<GtkStyle*>(gtkobj()), window, state_type, x1, x2, y);
}

void
Style::draw_vline(Gdk_Window     &window,
			   GtkStateType   state_type,
			   gint           y1,
			   gint           y2,
			   gint           x) const
{
  gtk_draw_vline(const_cast<GtkStyle*>(gtkobj()), window, state_type, y1, y2, x);
}

void
Style::draw_shadow(Gdk_Window     &window,
			    GtkStateType   state_type,
			    GtkShadowType  shadow_type,
			    gint           x,
			    gint           y,
			    gint           width,
			    gint           height) const
{
  gtk_draw_shadow(const_cast<GtkStyle*>(gtkobj()), window,
		  state_type, shadow_type, x, y, width, height);
}

void
Style::draw_polygon(Gdk_Window     &window,
			     GtkStateType   state_type,
			     GtkShadowType  shadow_type,
			     GdkPoint      *points,
			     gint           npoints,
			     gint           fill) const
{
  gtk_draw_polygon(const_cast<GtkStyle*>(gtkobj()), window,
		   state_type, shadow_type, points, npoints, fill);
}

void
Style::draw_arrow(Gdk_Window     &window,
			   GtkStateType   state_type,
			   GtkShadowType  shadow_type,
			   GtkArrowType   arrow_type,
			   gint           fill,
			   gint           x,
			   gint           y,
			   gint           width,
			   gint           height) const
{
  gtk_draw_arrow(const_cast<GtkStyle*>(gtkobj()), window, state_type, shadow_type,
		 arrow_type, fill, x, y, width, height);
}

void
Style::draw_diamond(Gdk_Window     &window,
			     GtkStateType   state_type,
			     GtkShadowType  shadow_type,
			     gint           x,
			     gint           y,
			     gint           width,
			     gint           height) const
{
  gtk_draw_diamond(const_cast<GtkStyle*>(gtkobj()), window, state_type, shadow_type,
		   x, y, width, height);
}

void
Style::draw_oval(Gdk_Window     &window,
		     GtkStateType   state_type,
		     GtkShadowType  shadow_type,
		     gint x, gint y,
		     gint width, gint height) const
{
  gtk_draw_oval(const_cast<GtkStyle*>(gtkobj()), window,
		state_type, shadow_type, x, y, width, height);
}

void
Style::draw_string(Gdk_Window     &window,
		       GtkStateType   state_type,
		       gint x, gint y,
		       const nstring &str) const
{
  gtk_draw_string(const_cast<GtkStyle*>(gtkobj()), window, state_type, x, y, str.gc_str());
}

void
Style::apply_default_background(const Gdk_Drawable &window,
				    bool set_bg,
				    GtkStateType state_type,
				    const Gdk_Rectangle &area,
				    gint x, gint y,
				    gint width, gint height)
{
  gtk_style_apply_default_background(gtkobj(), window, set_bg,
				     state_type, gdk_const_cast(area),
				     x, y,
				     width, height);
}

}
