// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_RC_H
#define _GTKMM_RC_H

#include <glibmm.h>

/* $Id: rc.h,v 1.1 2005/03/22 21:06:04 taybin Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


//#include <gtkmm/settings.h>
#include <gtkmm/style.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkRcStyle GtkRcStyle;
typedef struct _GtkRcStyleClass GtkRcStyleClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class RcStyle_Class; } // namespace Gtk
namespace Gtk
{

class Widget;
class Settings;
class Style;


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%RcFlags operator|(RcFlags, RcFlags)</tt><br>
 * <tt>%RcFlags operator&(RcFlags, RcFlags)</tt><br>
 * <tt>%RcFlags operator^(RcFlags, RcFlags)</tt><br>
 * <tt>%RcFlags operator~(RcFlags)</tt><br>
 * <tt>%RcFlags& operator|=(RcFlags&, RcFlags)</tt><br>
 * <tt>%RcFlags& operator&=(RcFlags&, RcFlags)</tt><br>
 * <tt>%RcFlags& operator^=(RcFlags&, RcFlags)</tt><br>
 */
enum RcFlags
{
  RC_FG = 1 << 0,
  RC_BG = 1 << 1,
  RC_TEXT = 1 << 2,
  RC_BASE = 1 << 3
};

/** @ingroup gtkmmEnums */
inline RcFlags operator|(RcFlags lhs, RcFlags rhs)
  { return static_cast<RcFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline RcFlags operator&(RcFlags lhs, RcFlags rhs)
  { return static_cast<RcFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline RcFlags operator^(RcFlags lhs, RcFlags rhs)
  { return static_cast<RcFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline RcFlags operator~(RcFlags flags)
  { return static_cast<RcFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline RcFlags& operator|=(RcFlags& lhs, RcFlags rhs)
  { return (lhs = static_cast<RcFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline RcFlags& operator&=(RcFlags& lhs, RcFlags rhs)
  { return (lhs = static_cast<RcFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline RcFlags& operator^=(RcFlags& lhs, RcFlags rhs)
  { return (lhs = static_cast<RcFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::RcFlags> : public Glib::Value_Flags<Gtk::RcFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class RcStyle : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef RcStyle CppObjectType;
  typedef RcStyle_Class CppClassType;
  typedef GtkRcStyle BaseObjectType;
  typedef GtkRcStyleClass BaseClassType;

private:  friend class RcStyle_Class;
  static CppClassType rcstyle_class_;

private:
  // noncopyable
  RcStyle(const RcStyle&);
  RcStyle& operator=(const RcStyle&);

protected:
  explicit RcStyle(const Glib::ConstructParams& construct_params);
  explicit RcStyle(GtkRcStyle* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~RcStyle();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkRcStyle*       gobj()       { return reinterpret_cast<GtkRcStyle*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkRcStyle* gobj() const { return reinterpret_cast<GtkRcStyle*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkRcStyle* gobj_copy();

private:

  
protected:
  RcStyle();

public:
  
  static Glib::RefPtr<RcStyle> create();

  
  /** Makes a copy of the specified Gtk::RcStyle. This function
   * will correctly copy an RC style that is a member of a class
   * derived from Gtk::RcStyle.
   * @return The resulting Gtk::RcStyle.
   */
  Glib::RefPtr<RcStyle> copy() const;

  void set_name(const Glib::ustring& name);
  Glib::ustring get_name() const;

  void set_bg_pixmap_name(Gtk::StateType state, const Glib::ustring& name);
  Glib::ustring get_bg_pixmap_name(Gtk::StateType state) const;

  void set_font(const Pango::FontDescription& font_desc);
  Pango::FontDescription get_font() const;
 
  void set_color_flags(Gtk::StateType state, RcFlags flags);
  void unset_color_flags(Gtk::StateType state, RcFlags flags);
  RcFlags get_color_flags(Gtk::StateType state) const;

  void set_fg(Gtk::StateType state, const Gdk::Color& color);
  Gdk::Color get_fg(Gtk::StateType state) const;

  void set_bg(Gtk::StateType state, const Gdk::Color& color);
  Gdk::Color get_bg(Gtk::StateType state) const;

  void set_text(Gtk::StateType state, const Gdk::Color& color);
  Gdk::Color get_text(Gtk::StateType state) const;

  void set_base(Gtk::StateType state, const Gdk::Color& color);
  Gdk::Color get_base(Gtk::StateType state) const;


  void set_xthickness(int xthickness);
  int get_xthickness() const;

  void set_ythickness(int ythickness);
  int get_ythickness() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


class RC
{
public:
  explicit RC(const Glib::ustring& filename);

  /** Finds all matching RC styles for a given widget,
   * composites them together, and then creates a
   * Gtk::Style representing the composite appearance.
   *
   * @param widget a Gtk::Widget.
   * @result the resulting style.
   */
  static Glib::RefPtr<Style> get_style(const Widget& widget);

  static void parse_string(const Glib::ustring &rc_string);

  /** Adds a file to the list of files to be parsed at the end of gtk_init().
   *
   * @param filename the pathname to the file. If @a filename is not absolute, it is searched in the current directory.
   */
  static void add_default_file(const Glib::ustring& filename);

  /** Sets the list of files that GTK+ will read at the end of gtk_init().
   *
   * @param filenames A list of filenames.
   */
  static void set_default_files(const Glib::StringArrayHandle& filenames);

  /** Retrieves the current list of RC files that will be parsed
   * at the end of gtk_init().
   *
   * @result An array of filenames.
   */
  static Glib::StringArrayHandle get_default_files();

  /** If the modification time on any previously read file for the
   * default Gtk::Settings has changed, discard all style information
   * and then reread all previously read RC files.
   *
   * @result true if the files were reread.
   */
  static bool reparse_all();

  /** If the modification time on any previously read file
   * for the given Gtk::Settings has changed, discard all style information
   * and then reread all previously read RC files.
   *
   * @param settings a Gtk::Settings
   * @param force_load load whether or not anything changed
   * @result true if the files were reread.
   */
  static bool reparse_all(const Glib::RefPtr<Settings>& settings, bool force_load = true);

  /** This method recomputes the styles for all widgets that use a
   * particular Gtk::Settings object. (There is one Gtk::Settings object
   * per Gdk::Screen -  see Gtk::Settings::get_for_screen()); It is useful
   * when some global parameter has changed that affects the appearance
   * of all widgets, because when a widget gets a new style, it will
   * both redraw and recompute any cached information about its
   * appearance. As an example, it is used when the default font size
   * set by the operating system changes. Note that this function
   * doesn't affect widgets that have a style set explicitely on them
   * with Gtk::Widget::set_style().
   *
   * @param settings a Gtk::Settings
   *
   * Since: 2.4
   */
  static void reset_styles(const Glib::RefPtr<Settings>& settings);

  /** Looks up a file in pixmap path for the specified Gtk::Settings.
   * If the file is not found, it outputs a warning message using
   * g_warning() and returns an empty string.
   *
   * @param settings a Gtk::Settings
   * @param scanner Scanner used to get line number information for the warning message.
   * @param pixmap_file name of the pixmap file to locate.
   * @result the filename.
   */
  static Glib::ustring find_pixmap_in_path(const Glib::RefPtr<Settings>& settings, GScanner* scanner, const Glib::ustring& pixmap_file);

  /** Looks up a file in pixmap path for the specified Gtk::Settings.
   * If the file is not found, it outputs a warning message using
   * g_warning() and returns an empty string.
   *
   * @param settings a Gtk::Settings
   * @param pixmap_file name of the pixmap file to locate.
   * @result the filename.
   */
  static Glib::ustring find_pixmap_in_path(const Glib::RefPtr<Settings>& settings, const Glib::ustring& pixmap_file);

  /** Searches for a theme engine in the GTK+ search path. This function
   * is not useful for applications and should not be used.
   *
   * @param pixmap_file  name of a theme engine.
   * @result The filename, if found, otherwise an empty string.
   **/
  static Glib::ustring find_module_in_path(const Glib::ustring& pixmap_file);

  static Glib::ustring get_theme_dir();

  /** Returns a directory in which GTK+ looks for theme engines.
   * For full information about the search for theme engines,
   * see the GTK+ docs.
   *
   * @result the directory.
   **/
  static Glib::ustring get_module_dir();
  
};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::RcStyle
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::RcStyle> wrap(GtkRcStyle* object, bool take_copy = false);
}


#endif /* _GTKMM_RC_H */

