/*
 * Copyright (c) 2000-2004 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1988-1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @(#) $Header: /usr/local/cvsroot/argus/include/interface.h,v 1.13 2004/02/23 15:00:36 argus Exp $ (LBL)
 */

#ifndef __STDC__
#define const
#endif
#ifdef __GNUC__
#define inline __inline
#else
#define inline
#endif

#include "os.h"			/* os dependent stuff */

#ifndef SIGRET
#define SIGRET void             /* default */
#endif

struct ArgusTokenStruct {
   int v;                  /* value */
   char *s;                /* string */
};


#ifdef ARGUS
#define MIN_SNAPLEN 96

int Cflag = 0;		/* modify ICMP flow model - printout each ICMP packet*/
int Rflag = 0;		/* modify ICMP flow model - printout each ICMP ECHO response */
int dflag = 0;		/* print interval code */
int wflag = 0;		/* write tcp connection data to wfile */
int lflag = 0;		/* print lasttime instead of startime */
int nflag = 0;		/* leave addresses as numbers */
int debugflag = 0;	/* set debug level */
int  tcptimeout = 0;	/* set  TCP timeout value (default  TCPTIMEOUT) */
int  udptimeout = 0;	/* set  UDP timeout value (default  UDPTIMEOUT) */
int   iptimeout = 0;	/* set   IP timeout value (default   IPTIMEOUT) */
int icmptimeout = 0;	/* set ICMP timeout (default ICMPTIMEOUT) */
int fragtimeout = 0;	/* set fragment timeout (default FRAGTIMEOUT) */
int Nflag;               /* remove domains from printed host names */

char *wfile;
char *program_name;

double update_interval = 1.0, update_time = 0.0;
int updatecounter = 0;
 
extern pcap_handler lookup_pcap_callback (void);
 
int lfd = -1;
int snaplen = MIN_SNAPLEN;

fd_set readmask, writemask, exceptmask;

pcap_t *pd = NULL;

#define ARGUS_PORT      561

#else

extern int Cflag;		/* print each ICMP packet */
extern int Rflag;		/* print each ICMP record on response for RTT */
extern int dflag;		/* print interval code */
extern int wflag;		/* write tcp connection data */
extern int nflag;		/* leave addresses as numbers*/
extern int debugflag;		/* set debug level */
extern int tcptimeout;		/* set TCP timeout value (default TCPTIMEOUT) */
extern int udptimeout;		/* set UDP timeout value (default UDPTIMEOUT) */
extern int  iptimeout;		/* set  IP timeout value (default  IPTIMEOUT) */
extern int icmptimeout;		/* set ICMP timeout (default ICMPTIMEOUT) */
extern int fragtimeout;		/* set ICMP timeout (default ICMPTIMEOUT) */
extern int Nflag;               /* remove domains from printed host names */

extern double update_interval;
extern int updatecounter;

extern char *wfile;
extern char *program_name;

extern int lfd;
extern int snaplen;

extern fd_set readmask, writemask, exceptmask;
extern pcap_t *pd;
#endif

#ifndef min
#define min(a,b) ((a)>(b)?(b):(a))
#define max(a,b) ((b)>(a)?(b):(a))
#endif

extern char timestamp_fmt[];
extern long timestamp_scale;
extern void timestampinit(void);

extern int fn_print(const u_char *, const u_char *);
extern int fn_printn(const u_char *, u_int, const u_char *);
extern const char *tok2str(const struct ArgusTokenStruct *, const char *, int);
extern char *dnaddr_string(u_short);
extern char *savestr(const char *);

extern char *isonsap_string(const u_char *);
extern char *llcsap_string(u_char);
extern char *protoid_string(const u_char *);
extern char *dnname_string(u_short);
extern char *dnnum_string(u_short);

