/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_P_STRING_NUM_LOOP_H_
#define _D_P_STRING_NUM_LOOP_H_

#include "PStringDatum.h"
#include "Util.h"
#include "PStringSegment.h"
#include "NumberDecorator.h"

class PStringNumLoop : public PStringDatum
{
private:
  
  int32_t _startValue;

  int32_t _endValue;

  int32_t _step;

  NumberDecoratorHandle _numberDecorator;

  PStringDatumHandle _next;

public:
  PStringNumLoop(int32_t startValue, int32_t endValue, int32_t step,
		 const NumberDecoratorHandle& nd,
		 const PStringDatumHandle& next = 0):
    _startValue(startValue),
    _endValue(endValue),
    _step(step),
    _numberDecorator(nd),
    _next(next) {}

  virtual ~PStringNumLoop() {}

  virtual void accept(const PStringVisitorHandle& visitor)
  {
    for(int32_t i = _startValue; i <= _endValue; i += _step) {
      PStringSegment(_numberDecorator->decorate(i), _next).accept(visitor);
    }
  }

  PStringDatumHandle getNext() const
  {
    return _next;
  }

  int32_t getStartValue() const
  {
    return _startValue;
  }

  int32_t getEndValue() const
  {
    return _endValue;
  }

  int32_t getStep() const
  {
    return _step;
  }

};

typedef SharedHandle<PStringNumLoop> PStringNumLoopHandle;

#endif // _D_P_STRING_NUM_LOOP_H_
