-- $Id: player.lua,v 1.5 2003/03/16 17:21:28 mat Exp $
-- Arkhart RPG - An Ark-based roleplaying game.
-- Copyright (C) 2001 The Contributors of the Arkhart Project
-- Please see the file "AUTHORS" for a list of contributors
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- Player class
player = {}
function player.on_create (self)
   self:set_aidriven (0)
   --self:psys_set (0,
   --		  "(0.0,+5.0,.00)(-.20,-4.0,0.0)(5.0)",
   --		  "(R,G,R)(G,G,G)",
   --		  "(1000, {particles}/rain.akp");
   self:play_anim(ark.play_loop, "idle");

   --self:psys_set (0,
   --		  "(0.0,+5.0,.00)(-.20,-1.0,0.0)(5.0)",
   --		  "(R,G,R)(G,G,G)",
   --		  "(1000, {particles}/snow.akp");
end

-- Called whenever the goal has been reached
function player.on_goal_reached (self)
	ark.log ("Player goal reached\n");
	self:play_anim (ark.play_loop, "look-idle");
end

function player.on_tell (self, msg)
	-- Don't remove the message from the list :
	-- the player needs to be able to read it !
	return 0;
end

function player.on_simplehit(self, col, pot)
	if pot == nil then
	--  ark.log("Player simplehit " .. col:get_name() .."\n");
	end

	return 1;
end
