/*
 * Copyright (c) 1995 - 2000, 2004 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include <nnpfs/nnpfs_locl.h>
#include <nnpfs/nnpfs_message.h>
#include <nnpfs/nnpfs_msg_locl.h>
#include <nnpfs/nnpfs_fs.h>
#include <nnpfs/nnpfs_dev.h>
#include <nnpfs/nnpfs_deb.h>

RCSID("$Id: nnpfs_dev-osf.c,v 1.12 2004/02/08 16:29:58 lha Exp $");

static int
nnpfs_devopen(dev_t dev, int flag, int format)
{
    NNPFSDEB(XDEBDEV, ("nnpfsopen dev = %d.%d, flag = %d, format = %d\n", 
		     major(dev), minor(dev), flag, format));
    return nnpfs_devopen_common(dev);
}

static int
nnpfs_devclose(dev_t dev, int flag, int format)
{
    NNPFSDEB(XDEBDEV, ("nnpfsclose dev = %d.%d, flag = %d, format = %d\n", 
		     major(dev), minor(dev), flag, format));
    return nnpfs_devclose_common(dev, u.u_procp);
}

/*
 * Not used.
 */

static int
nnpfs_devioctl(dev_t dev, 
	     unsigned int cmd, caddr_t data, int flags)
{
    NNPFSDEB(XDEBDEV, ("nnpfs_devioctl dev = %d.%d, cmd = %lu, "
		     "data = %lx, flags = %x\n", 
		     major(dev), minor(dev), (unsigned long)cmd, data, flags));
    return EINVAL;
}

/*
 * Are there any messages on this filesystem?
 */

static int
nnpfs_devselect(dev_t dev, short *events, short *revents, int scanning)
{
    struct nnpfs *chan = &nnpfs_dev[minor(dev)];
    if(*events & POLLNORM) {
	if(scanning) {
	    if (!nnpfs_emptyq(&chan->messageq))
		*revents |= POLLNORM; /* Something to read */
	    else
		select_enqueue(&chan->sel_q);
	} else {
	    select_dequeue(&chan->sel_q);
	}
    }
    if(*events & POLLOUT) {
	/* select for writing */
    }
    return 0;
}

void
nnpfs_select_wakeup(struct nnpfs *chan)
{
    select_wakeup(&(chan)->sel_q);
}

/*
 * Install and uninstall device.
 */

#if 0
struct driver nnpfsdriver = {
    NULL, /* probe */
    NULL, /* slave */
    NULL, /* cattach */
    NULL, /* dattach */
    NULL, /* go */
    NULL, /* addr_list */
    NULL, /* dev_name */
    NULL, /* dev_list */
    "nnpfs", 
    NULL, /* ctlr_list */
    0,    /* xclu */
    0,    /* addr1_size */
    0,    /* addr1_atype */
    0,    /* addr2_size */
    0,    /* addr2_atype */
    NULL, /* ctlr_unattach */
    NULL, /* dev_unattach */
};
#endif

extern int nodev();

struct dsent nnpfs_dsent = {
    nnpfs_devopen,
    nnpfs_devclose,
    nodev, /* strategy */
    nnpfs_devread,
    nnpfs_devwrite,
    nnpfs_devioctl,
    nodev, /* dump */
    nodev, /* psize */
    nodev, /* stop */
    nodev, /* reset */
    nnpfs_devselect,
    nodev, /* mmap */
    nodev, /* segmap */
    NULL, /* ttys */
    DEV_FUNNEL,
    0, /* bflags */
    0  /* cflags */
};

int nnpfs_dev_major;

int
nnpfs_install_device()
{
    int i;

    nnpfs_dev_major = devsw_add("nnpfs", 0, 64, &nnpfs_dsent);
    if(nnpfs_dev_major < 0)
	nnpfs_dev_major = devsw_add("nnpfs", 0, -1, &nnpfs_dsent);
    if(nnpfs_dev_major < 0)
	return ENODEV;
    
    for (i = 0; i < NNNPFS; i++) {
	NNPFSDEB(XDEBDEV, ("before initq(messageq and sleepq)\n"));
	nnpfs_initq(&nnpfs_dev[i].messageq);
	nnpfs_initq(&nnpfs_dev[i].sleepq);
	nnpfs_dev[i].status = 0;
	queue_init(&nnpfs_dev[i].sel_q.links);
    }
    return 0;
}

int
nnpfs_uninstall_device()
{
    int i;
    dev_t dev;
    struct nnpfs *chan;
    for (i = 0; i < NNNPFS; i++) {
	dev = makedev(nnpfs_dev_major, i);
	chan = &nnpfs_dev[minor(dev)];
	if (chan->status & CHANNEL_OPENED)
	    nnpfs_devclose(dev, 0, 0);
    }
    if(devsw_del("nnpfs", 0) < 0)
	return ESRCH;
    return 0;
}
