/*
 * Copyright (c) 2003-2004 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL").
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* 
 * Orignally written for OpenAFS by Chaskiel Grundman <cg2v@andrew.cmu.edu>,
 * mudged somewhat by Love <lha@it.su.se>.
 */

#define __NO_VERSION__

#include <nnpfs/nnpfs_locl.h>
#include <nnpfs/nnpfs_dev.h>
#include <nnpfs/nnpfs_debug.h>
#include <nnpfs/nnpfs_syscalls.h>
#include <nnpfs/nnpfs_common.h>
#include <linux/file.h>

#ifdef RCSID
RCSID("$Id: nnpfs_syscalls-lossage.c,v 1.5 2004/06/03 08:55:06 tol Exp $");
#endif


#ifndef HAVE_KERNEL_SYS_CALL_TABLE

#ifndef LINUX2_5
#ifdef __ver_sys_close
#define HAVE_KERNEL_SYS_CLOSE 1
#endif

#ifdef __ver_sys_chdir
#define HAVE_KERNEL_SYS_CHDIR 1
#endif
#endif /* !LINUX2_5 */


#include <linux/sched.h>
#include <linux/kallsyms.h>

#ifdef LINUX2_5
#include <linux/syscalls.h>
#else
#include <linux/syscall.h>
#endif


nnpfs_sys_call_function *sys_call_table;

#ifdef LINUX2_5

static inline int 
kallsym_is_equal(unsigned long addr, const char *name)
{
    char namebuf[128];
    const char *retname;
    unsigned long size, offset;
    char *modname;

    retname = kallsyms_lookup(addr, &size, &offset, &modname, namebuf);
    if (retname != NULL	&& strcmp(name, retname) == 0 && offset == 0)
        return 1;

    return 0;
}

#define GOOD(name)						\
	(kallsym_is_equal((unsigned)ptr[__NR_##name], "sys_" #name))
#else
#define GOOD(name)				       		\
	(ptr[__NR_##name] == (nnpfs_sys_call_function)&sys_##name)
#endif /* !LINUX2_5 */

#define CHECK_SYSCALL(first, second)		       		\
        if (GOOD(first) && GOOD(second)) {			\
            sys_call_table = ptr;				\
	}

int
nnpfs_fixup_syscall_lossage(void)
{
    nnpfs_sys_call_function *ptr = (nnpfs_sys_call_function *)&init_mm;
    nnpfs_sys_call_function *limit;

    sys_call_table = NULL;

    for (limit = ptr + 16 * 1024;
	 ptr < limit && sys_call_table == NULL; ptr++)
    {
#ifdef LINUX2_5
        CHECK_SYSCALL(close,chdir);
#else
#if defined(HAVE_KERNEL_SYS_CLOSE) && defined(HAVE_KERNEL_SYS_CHDIR)
	CHECK_SYSCALL(close,chdir);
#else
	CHECK_SYSCALL(exit,open);
#endif
#endif
    }

    if (sys_call_table == NULL) {
	printk("Failed to find address of sys_call_table\n");
 	return -EIO;
    }

    printk("Found sys_call_table at %p\n", sys_call_table);

    return 0;
}
#endif /* !HAVE_KERNEL_SYS_CALL_TABLE */
