/*
  
*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_STRING_H
#define ArmageTron_STRING_H

#include "tArray.h"
#include "tMemStack.h"

#include <sstream>
#include <iostream>
#include <iosfwd>

//typedef tArray<char> string;
class tOutput;

class tString:public tArray<char>{
 private:
 public:
	tString();
	tString(const char *);
	tString(const tString &);
	tString(const tOutput &);

	void ReadLine(std::istream &s);

	tString & operator+=(const char *c);
	tString & operator=(const char *c);
	tString & operator<<(const char *c);
	tString operator+(const char *c) const;
	tString & operator<<(char c);
	tString & operator+=(char c);
	tString operator+(char c) const;

	operator const char*() const;

	tString & operator =(const tString &s);
	tString & operator =(const tOutput &s);
	tString & operator+=(const tString &s);

	bool operator==(const tString &other) const;

//	static char * ReserveTempString();
//	static int    TempStringLength();
//	static void   MakeTempStringLonger();
//	static void   FreeTempString();

	void Clear(){tArray<char>::Clear(); }

	void SetPos( int len, bool cut );

	static int CompareAlphaNumerical( const tString& a, const tString &b);
	int GetInt( int& pos ) const ;	// exctact the integer at position pos plus 2^16 ( or the character )
};

std::ostream & operator<< (std::ostream &s,const tString &x);
std::istream & operator>> (std::istream &s,tString &x);

//#define tMAX_STRING_OUTPUT 1000
//extern char st_stringOutputBuffer[tMAX_STRING_OUTPUT];

/*
  tString & operator <<(tString &s,const char* c){
  return s+=c;
  }

  tString & operator <<(tString &s,char c){
  return s+=c;
  }
*/

template<class T> tString & operator <<(tString &s,const T &c)
{
	std::ostringstream S;
  
	S << c << '\0';

	return s+=S.str().c_str();
}

std::stringstream& operator<<(std::stringstream& s, const tString &t);
//std::stringstream& operator<<(std::stringstream& s, const int &t);
//std::stringstream& operator<<(std::stringstream& s, const float &t);
//std::stringstream& operator<<(std::stringstream& s, const short unsigned int &t);
//std::stringstream& operator<<(std::stringstream& s, const short int &t);
//std::stringstream& operator<<(std::stringstream& s, const unsigned int &t);
//std::stringstream& operator<<(std::stringstream& s, const unsigned long &t);
//std::stringstream& operator<<(std::stringstream& s, char t);
//std::stringstream& operator<<(std::stringstream& s, bool t);
//std::stringstream& operator<<(std::stringstream& s, const char * const &t);


/*
  void operator <<(tString &s,const char * c);
  void operator <<(tString &s,const unsigned char * c);
  void operator <<(tString &s,int c);
  void operator <<(tString &s,float c);
*/


#endif


