#!/bin/sh

# NOTE: Make sure you disable rp_filter in the firewall!
MY_VERSION="0.12BETA"
# ------------------------------------------------------------------------------------------
#                       -= Arno's iptables firewall =-
#                         Multirouting setup script
#
# (C) Copyright 2005-2006 by Arno van Amersfoort
# Homepage              : http://rocky.eld.leidenuniv.nl/
# Freshmeat homepage    : http://freshmeat.net/projects/iptables-firewall/?topic_id=151
# Email                 : a r n o v a AT r o c k y DOT e l d DOT l e i d e n u n i v DOT n l
#                         (note: you must remove all spaces and substitute the @ and the .
#                          at the proper locations!)
# ------------------------------------------------------------------------------------------
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# ------------------------------------------------------------------------------------------

# Settings for the first interface:
EXT_IF1=eth0
EXT_ROUTER1=1.2.3.5
EXT_IP1=5.6.7.9

# Settings for the second interface:
EXT_IF2=eth1
EXT_ROUTER2=1.2.3.4
EXT_IP2=5.6.7.8

# RP_FILTER settings (Only set this to 0, if you know what you're doing)
RP_FILTER_DISABLE=1

# Optional settings if you also use an internal interface (for your LAN / gateway)
INT_IP=192.168.0.1
INT_NET=192.168.0.0/24

echo -e "\033[40m\033[1;32mMultiroute Setup Script v$MY_VERSION - (C) 2005 Arno van Amersfoort\033[0m"
echo "-------------------------------------------------------------------------------"

# In some cases the rp_filter gives some problems, so we disable it and rely on the
# anti-spoof rules in the firewall
if [ "$RP_FILTER_DISABLE" == "1" ]; then
  echo "Disabling RP_FILTER..."
  echo "0" >/proc/sys/net/ipv4/conf/$EXT_IF1/rp_filter
  echo "0" >/proc/sys/net/ipv4/conf/$EXT_IF2/rp_filter
fi

# Setup source IP routing rules for external interface 1
echo "Setup source IP routing for $EXT_IP1"
ip rule add from $EXT_IP1 lookup 1
#ip route replace 0/0 via $EXT_ROUTER1 table 1
ip route replace default via $EXT_ROUTER1 dev $EXT_IF1 table 1
ip route replace $INT_NET via $INT_IP table 1

# Setup source IP routing rules for external interface 2
echo "Setup source IP routing for $EXT_IP2"
ip rule add from $EXT_IP2 lookup 2
#ip route replace 0/0 via $EXT_ROUTER2 table 2
ip route replace default via $EXT_ROUTER2 dev $EXT_IF2 table 2
ip route replace $INT_NET via $INT_IP table 2

# Setup the actual loadbalancing
echo "Enabling loadbalancing over $EXT_IF1 and $EXT_IF2"
ip route replace default equalize \
	nexthop via $EXT_ROUTER1 dev $EXT_IF1 \
	nexthop via $EXT_ROUTER2 dev $EXT_IF2

# Flush route cache
#echo "1" >/proc/sys/net/ipv4/route/flush
ip route flush cache

# Return success
exit 0
