/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __ARSON_H__
#define __ARSON_H__

#include <kapp.h>

#include "../config.h"
#include "tsutil.h"

/*==================================*/
/*	DEFINES
 *==================================*/

#define DISPLAYNAME	"arson"
#define DESCRIPTION	"A cd-writer front-end."
#define HOMEPAGE	"http://arson.sourceforge.net/"
#define BUGEMAIL	"tonys111@users.sourceforge.net"
#define MYNAME		"Tony Sideris"

#define DBGOUT		Trace

/*========================================================*/

class ArsonError	//	Exception type
{
public:
	ArsonError (const QString &desc)
		: m_desc(desc) {}

	const QString &description (void) const { return m_desc; }

	virtual void report (void) const;

private:
	QString m_desc;
};

class ArsonStartupError : public ArsonError
{
public:
	ArsonStartupError (const QString &desc, const char *dontShowAgain)
		: ArsonError(desc), m_cfgKey(dontShowAgain) { }

	virtual void report (void) const;

private:
	const char *m_cfgKey;
};

/*========================================================*/

class ArsonNetFile
{
public:
	ArsonNetFile (void) {}
	ArsonNetFile (const KURL &url);
	~ArsonNetFile (void);

	const QString &path (void) const { return m_local; }

private:
	QString m_local;
	bool m_bLocal;
};

/*========================================================*/

class KCmdLineArgs;

class ArsonApp : public KApplication
{
public:
	ArsonApp (int argc, char **argv);

	KCmdLineArgs *handleCmdLine (void);
	int main (void);
};

/*========================================================*/

class ArsonFileListDoc;

class ArsonFileFilter
{
	class Filter {
	public:
		Filter (const QString &str = QString::null) { fromString(str); }
		Filter (const QString &desc, const QString &filter)
			: m_desc(desc), m_filter(filter) { }

		void fromString (const QString &str);
		QString toString (void) const;

		const QString &filter (void) const { return m_filter; }
		const QString &desc (void) const { return m_desc; }

	private:
		QString m_filter;
		QString m_desc;
	};

	typedef QValueList<Filter> FILTERS;
	
public:
	enum {
		AllFiles = 0x01,
		AllTypes = 0x02,
		Default = (AllFiles | AllTypes)
	};

	ArsonFileFilter (uint flags = Default) : m_flags(flags) { }
	ArsonFileFilter (const QString &init, uint flags = Default);
	ArsonFileFilter (const QString *arr, size_t cnt, uint flags = Default);
	ArsonFileFilter (ArsonFileListDoc *pd, uint flags = Default);

	void fromString (const QString &str);
	QString toString (void) const;
	QString filters (void) const;

	void addFilter (const QString &desc, const QString &filter);
	void addFilter (const QString &str);

private:
	FILTERS m_filters;
	uint m_flags;
};

/*========================================================*/

#include "_listview.h"

class QCheckListItem;

class ArsonRadioDlg : public ArsonListviewDlgBase
{
public:
	ArsonRadioDlg (QWidget *parent = NULL);

	const QString &selection (void) const { return m_sel; }

	void addItem (const QString &item);

private:
	virtual void accept (void);

	QCheckListItem *m_group;
	QCheckListItem *m_last;
	QString m_sel;
};

/*========================================================*/

class QXmlContentHandler;
class QTextStream;
class QDomDocument;
class QListBox;
class KURL;

bool arsonIsExecutable (const char *path);
QString arsonDisplayTime (int secs);
QString arsonByteSize (uint nbytes);

QCString arsonDataFile (const char *filename,
	const char *res = NULL,
	bool local = false);

bool arsonWarning (const QString &msg, const QString &save_at);
void arsonErrorMsg (const QString &msg);
void arsonNotify (const QString &msg = QString::null);

bool arsonOpenDomDocument (const KURL &url, QDomDocument &dom);
bool arsonOpenDomDocument (const QString &fn, QDomDocument &dom);
void arsonOpenDoc (const KURL &url);

bool arsonParseXml (QTextStream *ps, QXmlContentHandler *ph);
bool arsonParseXml (const KURL &url, QXmlContentHandler *ph);

void arsonSaveLogWindow (QListBox *pl, const QString &fn = QString::null);

/*========================================================*/
#endif	/*	__ARSON_H__	*/
