/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __CDDB_H__
#define __CDDB_H__

#include "cdinfowaitdlg.h"
#include "cdinfo.h"
#include "socket.h"

/*========================================================*/

class ArsonCddbBaseSocket : public ArsonHttpGetSocket
{
public:
	ArsonCddbBaseSocket (const ArsonCdInfo &info,
		const QString &host, short port);

protected:
	virtual ArsonHttpCommand cddbCommand (void) const = 0;

	virtual QString path (void) const;
	virtual QString request (void) const;

	const ArsonCdInfo &m_info;
};

class ArsonCddbQuerySocket : public ArsonCddbBaseSocket
{
public:
	ArsonCddbQuerySocket (const ArsonCdInfo &info,
		const QString &host, short port);

protected:
	virtual ArsonHttpCommand cddbCommand (void) const;
};

class ArsonCddbReadSocket : public ArsonCddbBaseSocket
{
public:
	ArsonCddbReadSocket (const ArsonCdInfo &info,
		const QString &categ, const QString &host, short port);

protected:
	virtual ArsonHttpCommand cddbCommand (void) const;

	QString m_categ;
};

/*========================================================*/

class ArsonCddbParserBase
{
public:
	ArsonCddbParserBase (QTextStream *ps);

	virtual bool checkResponse (void);
	virtual bool parse (void) = 0;

	static bool split (const QString &str,
		QString &lhs, QString &rhs,
		const QString &sep);

	static QCString encode (const QCString &str);
	static QCString decode (const QCString &str);
	
protected:
	QString nextLine (void);

	QTextStream *m_ps;
};

class ArsonCddbQueryParser : public ArsonCddbParserBase
{
public:
	ArsonCddbQueryParser (QTextStream *ps);

	virtual bool checkResponse (void);
	virtual bool parse (void);
	
	QString category (void) const;

	struct Category {
		QString categ;
		QString id;
		QString title;
	};

	typedef QValueList<Category> CATEGORIES;

protected:
	bool parseLine (const QString &line);
	
	CATEGORIES m_cats;
};

class ArsonCddbReadParser : public ArsonCddbParserBase
{
public:
	ArsonCddbReadParser (QTextStream *ps);

	void applyTo (ArsonCdInfo &info) const;
	QString value (const char *key) const;

	virtual bool parse (void);

	typedef QMap<QCString,QString> VALMAP;

protected:
	VALMAP m_map;
};

/*========================================================*/

class ArsonCddbDlg : public ArsonCdInfoWaitDlg
{
public:
	ArsonCddbDlg (const ArsonCdInfo &info, const QString &addr, short port);
	
protected:
	virtual void handleStream (QTextStream *pStream);
	virtual ArsonSocket *createSocket (void);

	QString m_categ;
	bool m_bQueried;
	QString m_addr;
	short m_port;
};

/*========================================================*/
#endif	/*	__CDDB_H__	*/
