/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __CDINFODLG_H__
#define __CDINFODLG_H__

#include "_cdinfoeditor.h"
#include "_listview.h"

#include "cdinfo.h"

/*========================================================*/

class genreParser;

class ArsonCdInfoEditor : public ArsonCdInfoDlgBase
{
	typedef QMap<int,int> LINKMAP;
	
public:
	ArsonCdInfoEditor (QWidget *parent, const ArsonCdInfo &info);

	const ArsonCdInfo &info (void) const { return m_info; }
	
protected:
	virtual void multi_artist_toggled (bool multi);
	virtual void genre_changed (int index);
	virtual void submit_clicked (void);
	virtual void reset_clicked (void);
	virtual void accept (void);

	int addGenre (const QString &genre, int link = -1);
	bool submitInfo (const ArsonCdInfo &info);
	void applyInfo (const ArsonCdInfo &info);
	void fillGenres (void);
	bool verify (void);

	LINKMAP m_links;
	ArsonCdInfo m_info;

	friend class genreParser;
};

/*========================================================*/

class ArsonLookupOrder;

class ArsonSubmitDlg : public ArsonListviewDlgBase
{
public:
	ArsonSubmitDlg (const ArsonCdInfo &info,
		const ArsonLookupOrder &lp,
		QWidget *parent);

private:
	virtual void accept (void);
	
	const ArsonLookupOrder &m_order;
	const ArsonCdInfo &m_info;
};

/*========================================================*/
#endif	/*	__CDINFODLG_H__	*/
