/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __DEVICEPAGE_H__
#define __DEVICEPAGE_H__

#include <qpixmap.h>

#include "_devicepage.h"
#include "configdlg.h"
#include "device.h"

/*========================================================*/

class QListViewItem;
class ArsonConfig;

class ArsonDevicePage : public ArsonDevicePageBase, public ArsonConfigPage
{
	Q_OBJECT
	
public:
	ArsonDevicePage (ArsonConfig &cfg, ArsonConfigDlg *pdlg, QWidget *parent);

private:
	virtual void rescan_clicked (void);
	virtual void modify_clicked (void);
	virtual void add_ioctl (void);
	virtual void del_ioctl (void);

	QString getDevPath (const QString &old = QString::null);
	bool inBranch (QListViewItem *item) const;
	QCString selectedKey (void) const;
	void fillIoctl (void);
	void fillScsi (void);

	ArsonDeviceList m_devs;
	QListViewItem *m_pIoctlHdr, *m_pIoctlNone;
	QListViewItem *m_pScsiHdr, *m_pScsiNone;
	QPixmap m_icon;

signals:
	void devsChanged (const ArsonDeviceList &devs);
	
private slots:
	void item_selected (QListViewItem *item);
	void on_accept (void);
};

/*========================================================*/
#endif	/*	__DEVICEPAGE_H__	*/
