/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __PROGRESSDLG_H__
#define __PROGRESSDLG_H__

#include <qvaluelist.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlineedit.h>

#include "_progressdlg.h"

/*========================================================*/

class ArsonProgressDlg;
class KConfig;

class ArsonCtrlState
{
public:
	ArsonCtrlState (ArsonProgressDlg *pd);

	ArsonCtrlState &operator>> (QCheckBox *pc);
	ArsonCtrlState &operator>> (QComboBox *pc);
	ArsonCtrlState &operator>> (QLineEdit *pe);

	ArsonCtrlState &operator<< (QCheckBox *pc);
	ArsonCtrlState &operator<< (QComboBox *pc);
	ArsonCtrlState &operator<< (QLineEdit *pe);

private:
	KConfig *m_pk;
};

/*========================================================*/

#define ARSON_CONNECT_PROGRESSCTRL(p,ctrl) \
	QObject::connect((p)->topLevelWidget(), SIGNAL(restoreState(ArsonCtrlState&)), \
	(ctrl), SLOT(onRestore(ArsonCtrlState&))); \
	QObject::connect((p)->topLevelWidget(), SIGNAL(saveState(ArsonCtrlState&)), \
	(ctrl), SLOT(onSave(ArsonCtrlState&)))

#define IMPLEMENT_PROGRESSCTRL_SLOTS(cls) \
	void cls::onRestore (ArsonCtrlState &state) { state >> this; } \
	void cls::onSave (ArsonCtrlState &state) { state << this; }

class ArsonProgressCheckbox : public QCheckBox
{
	Q_OBJECT
	
public:
	ArsonProgressCheckbox (const QString &label, QWidget *parent, const char *name = NULL);

private slots:
	void onRestore (ArsonCtrlState &state);
	void onSave (ArsonCtrlState &state);
};

class ArsonProgressCombobox : public QComboBox
{
	Q_OBJECT
	
public:
	ArsonProgressCombobox (QWidget *parent, const char *name = NULL);

private slots:
	void onRestore (ArsonCtrlState &state);
	void onSave (ArsonCtrlState &state);
};

class ArsonProgressLineedit : public QLineEdit
{
	Q_OBJECT

public:
	ArsonProgressLineedit (QWidget *parent, const char *name = NULL);

private slots:
	void onRestore (ArsonCtrlState &state);
	void onSave (ArsonCtrlState &state);
};

/*========================================================*/

class ArsonProcessOpts;
class ArsonProcessMgr;
class ArsonProcessUI;
class QWidget;
class QBoxLayout;
class QGroupBox;
class pushButtonLogUI;
class QHBoxLayout;
class QLayoutItem;

class ArsonProgressDlg : public ArsonProgressDlgBase
{
	Q_OBJECT
	
	typedef QValueList<QWidget*> WIDGETLIST;
	
public:
	virtual ~ArsonProgressDlg (void);

	void setWriter (ArsonProcessMgr *pWriter);
	ArsonProcessUI *ui (void);

	void output (const QString &str, bool error);
	void setText (const QString &text);
	void setMaxProgress (long maxp);
	void setProgress (long prog);
	void setProgressMode (int mode);

	struct WidgetMgr {
		WidgetMgr (ArsonProgressDlg *pd);
		WidgetMgr &operator<< (QWidget *pw);
	private:
		ArsonProgressDlg *m_pd;
	};

	struct LayoutRow {
		LayoutRow (ArsonProgressDlg *pd, bool indent = false);
		LayoutRow &operator<< (QWidget *pw);
		LayoutRow &operator<< (QLayoutItem *pl);
	private:
		ArsonProgressDlg *m_pd;
		QHBoxLayout *m_row;
	};
	
	QCheckBox *addCheckbox (const QString &text, const char *name, bool state = false);
	QHBoxLayout *makeLayoutRow (bool indent = false);
	bool isCheckboxChecked (const char *name);
	int addWidget (QWidget *widget, bool align = true);
	void setCaption (const QString &text);
	QBoxLayout *ctrlLayout (void);
	QWidget *ctrlParent (void);

	LayoutRow layoutRow (bool indent = false) { return LayoutRow(this, indent); }
	WidgetMgr widgetMgr (void) { return WidgetMgr(this); }

	virtual void beginWrite (void);
	virtual void endWrite (void);

	int exec (void);
	
private:
	virtual void start_clicked (void);

protected:
	ArsonProgressDlg (QWidget *parent, const char *name);
	ArsonProgressDlg (const ArsonProgressDlg&) {}

	ArsonProcessMgr *writer (void) { return m_pWriter; }
	QLayoutItem *spacer (int width = 6);
	void enableControls (bool enable);
	void _setCaption (void);

	virtual ArsonProcessMgr *createProcessMgr (void) = 0;
	virtual void processOpts (ArsonProcessOpts &opts) { }
	virtual void reconfigure (void) { }

	virtual void closeEvent (QCloseEvent *close);
	virtual void show_cmd_log (void);
	virtual void config_clicked (void);
	virtual void log_clicked (void);
	virtual void reject (void);
	virtual bool cancelWarning (void);

	ArsonProcessMgr *m_pWriter;
	QGroupBox *m_pBtnGroup;
	QBoxLayout *m_pBtnLayout;
	WIDGETLIST m_widgets;
	QString m_baseCaption;
	pushButtonLogUI *m_pLogUI;
	ArsonProcessUI *m_pUI;

signals:
	void restoreState (ArsonCtrlState &state);
	void saveState (ArsonCtrlState &state);
};

/*========================================================*/

class ArsonSimpleProgressDlg : public ArsonProgressDlg
{
public:
	ArsonSimpleProgressDlg(
		const QString &text,
		const QString &caption,
		QWidget *parent,
		const char *name);
};

/*========================================================*/
#endif	/*	__PROGRESSDLG_H__	*/
