/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 14:05:37 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class SequenceChangeEvent_ESTest extends SequenceChangeEvent_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(bases0).toString();
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 5, 5, "XRFVSv{:Y2hHE");
      sequenceChangeEvent0.getBases();
      assertEquals(5, sequenceChangeEvent0.getType());
      assertEquals(5, sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 2);
      int int0 = sequenceChangeEvent0.getType();
      assertEquals(2, int0);
      assertEquals(0, sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), 5, "7");
      int int0 = sequenceChangeEvent0.getType();
      assertEquals(5, sequenceChangeEvent0.getPosition());
      assertEquals((-5), int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 5, 5, "XRFVSv{:Y2hHE");
      sequenceChangeEvent0.getSubSequence();
      assertEquals(5, sequenceChangeEvent0.getPosition());
      assertEquals(5, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-48), (-499), "");
      sequenceChangeEvent0.getSubSequence();
      assertEquals((-48), sequenceChangeEvent0.getType());
      assertEquals((-499), sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 5, 5, "XRFVSv{:Y2hHE");
      int int0 = sequenceChangeEvent0.getPosition();
      assertEquals(5, int0);
      assertEquals(5, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-48), (-499), "");
      int int0 = sequenceChangeEvent0.getPosition();
      assertEquals((-499), int0);
      assertEquals((-48), sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      Range range0 = mock(Range.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 2573, range0, 2573);
      int int0 = sequenceChangeEvent0.getLength();
      assertEquals(2573, int0);
      assertEquals(2573, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 5, (Range) null, (-5));
      int int0 = sequenceChangeEvent0.getLength();
      assertEquals((-5), int0);
      assertEquals(5, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Range range0 = mock(Range.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent((Bases) null, 96, range0, 0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent((Bases) null, (-2844));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent((-1288), (-1288), (Range) null);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 2, 1, "");
      int int0 = sequenceChangeEvent0.getLength();
      assertEquals(0, int0);
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(2, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 0);
      int int0 = sequenceChangeEvent0.getPosition();
      assertEquals(0, sequenceChangeEvent0.getType());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Range range0 = mock(Range.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(0, 0, range0);
      // Undeclared exception!
      try { 
        sequenceChangeEvent0.getBases();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.Range$MockitoMock$633056633 cannot be cast to uk.ac.sanger.artemis.sequence.Bases
         //
         verifyException("uk.ac.sanger.artemis.sequence.SequenceChangeEvent", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 1);
      sequenceChangeEvent0.getRange();
      assertEquals(1, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent((Bases) null, 0, 0, "");
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 5, (Range) null, (-5));
      sequenceChangeEvent0.getSubSequence();
      assertEquals(5, sequenceChangeEvent0.getType());
      assertEquals((-5), sequenceChangeEvent0.getLength());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Range range0 = mock(Range.class, new ViolatedAssumptionAnswer());
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(0, 0, range0);
      int int0 = sequenceChangeEvent0.getType();
      assertEquals(0, int0);
      assertEquals(0, sequenceChangeEvent0.getPosition());
  }
}
