#ifndef sampletypeh
#define sampletypeh

#include <glib.h>

typedef struct __attribute__ ((packed))
{
  guint8 channels:4;         // 0 -> Mono, 1 -> Stereo, ...
  guint8 bits;               // Number of bits
  gboolean sign:1;           // Signed or unsigned?
  gboolean be:1;             // Big endian or little endian?
  guint32 rate;              // Sample rate
} SampleType;

#define sample_type_sample_size(st) (((st)->channels)*((st)->bits/8))
#define sample_type_bps(st) (sample_type_sample_size(st)*(st)->rate)
#define sample_type_equal(st1,st2) (((st1)->channels == (st2)->channels) && ((st1)->bits == (st2)->bits) && ((st1)->sign == (st2)->sign) && ((st1)->be == (st2)->be))

void sample_type_to_le(SampleType *t);
void sample_type_from_le(SampleType *t);
void sample_type_to_string(SampleType *t, gchar *s, guint l);
gboolean sample_type_valid(SampleType *t);

#endif
