#ifndef blocksh
#define blocksh

#include <glib.h>

#include <volume.h>

struct _Block;
typedef struct _Block Block;

#include <gc.h>
#include <latency.h>

struct _Block
{
  gulong size;        // block size in bytes
  Origin origin;
  Latency latency;
  gboolean dynamic;
};

extern Block* silence_block;  // a block with silence. Can be used for certain optimizations
extern guint block_count;            // how many blocks are allocated?

void block_init();
void block_done();

// Allocates a new block
Block* block_new();

// Returns a pointer to the sample data of the block
#define block_get_data(b) (((guint8*)(b))+sizeof(Block))

// Makes a copy of a block
Block* block_copy(Block *b);

// Returns a pointer to a block with reference-counter of 1 and the contents of the input block.
// This may or may not copy the block 
// The input block maybe invalid after call
// Should be called as follows: b = block_mutable(b);
Block* block_mutable(Block *b);

// Calculates a new block with decreased volume as specified.
// The input block may be invalid after function call.
// Should be called as follows: b = block_volume(b, v);
Block* block_volume(Block *b, Volume *v);

// Pads up a block to def_block_size with silence
// This won't make a copy because is not critical for multi threading
// The input pointer is returned to the caller
Block* block_pad(Block *b);

// Mixes several blocks together and returns a new block.
// The input blocks are invalid after function call
Block* block_mix_array(Block **b, guint l);

// Sets the size of a block
void block_set_size(Block *b, gulong l);

#endif
