------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--      A S I S _ U L . S O U R C E _ T A B L E . P R O C E S S I N G       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2004-2007, AdaCore                     --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not,  write  to the  Free Software Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the basic processing routines for the source file
--  table. We define them in a child package in case if some tools need only
--  the source table but not any stubs or templates for the processing of
--  the files from this table.

package ASIS_UL.Source_Table.Processing is

   procedure Initialize;
   --  This procedure is supposed to be called after the general initialization
   --  routine (ASIS_UL.Environment.Initialize), when all the tool command-line
   --  parameters are processed and all the argument files are stored in the
   --  file table.
   --
   --  This procedure is supposed to make some additional settings in the
   --  source file table based on some information other then the tool command
   --  line parameters. For example, it may read some configuration file(s) and
   --  as a result mark some for the argument files as not to be processed.
   --
   --  This routine is supposed to be provided by the tool developer (if any
   --  additional initialization is needed for the source table). At the
   --  moment, the ASIS Utility Library contains a placeholder for it, at some
   --  point it may be replaced with the code doing some processing of XML
   --  configuration file.

   procedure Process_Sources (Need_Semantic_Info : Boolean := True);
   --  Iterates though the source file table and calls the processing routine
   --  for each source. This procedure implement only iteration though the
   --  table, the specific processing routine(s) should be provided by the
   --  tool developer. Need_Semantic_Info controls the optimization when
   --  processing units on the base of the same tree, If you tool does need the
   --  detailed semating information, set this parameter ON, otherwise the
   --  information from expanded generics and program unit bodies may be lost.
   --  If your tool is purely syntactical, you may set this parameter OFF to
   --  speed up the processing.

   procedure Finalize;
   --  This procedure is supposed to be called after completing of the
   --  processing of all the sources stored in the source table that have
   --  to be and can be processed. It is supposed to summarize and to analyze
   --  some global information (if any) that has been generated during source
   --  processing.
   --
   --  This routine is supposed to be provided by the tool developer. The
   --  moment, the ASIS Utility Library contains a placeholder for it.

end ASIS_UL.Source_Table.Processing;
