/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.instrumentor.AbstractStrategy;
import alt.jiapi.instrumentor.HotSpot;
import alt.jiapi.instrumentor.Strategy;
import alt.jiapi.reflect.InstructionList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class SplitInstrumentor
extends AbstractInstrumentor {
    private static Category log = Runtime.getLogCategory(SplitInstrumentor.class);
    private Strategy strategy;

    public SplitInstrumentor(Strategy strategy) {
        log.info((Object)("SplitInstrumentor: " + strategy));
        this.strategy = strategy;
    }

    public void instrument(InstructionList il) {
        int end;
        log.info((Object)("Instrumenting " + this.getCurrentClass().getName() + "." + il.getDeclaringMethod().getName()));
        ((AbstractStrategy)this.strategy).setInstrumentation(this.getInstrumentation());
        List boundaries = this.strategy.findHotSpots(il);
        Iterator iter = boundaries.iterator();
        int start = 0;
        int count = 0;
        HotSpot boundary = null;
        while (iter.hasNext()) {
            ++count;
            boundary = (HotSpot)iter.next();
            end = boundary.getStart() - 1;
            if (end < start) {
                end = start;
            }
            InstructionList view = il.createView(start, end);
            this.forward(view);
            start = boundary.getEnd() + 1;
        }
        if (boundary != null && (end = boundary.getEnd() + 1) <= il.size()) {
            this.forward(il.createView(end, il.size()));
        }
    }

    public String toString() {
        return super.toString() + "#" + this.strategy.toString();
    }
}

