/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.util;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import jd.io.Encoding;
import jd.io.TabWriter;
import jd.util.TextBuffer;

public class XmlWriter
extends TabWriter {
    private static final String LINE_SEPARATOR = String.valueOf('\n');
    private Encoding encoding_;
    private TextBuffer buffer_ = new TextBuffer();

    public XmlWriter(OutputStream outputStream, String string, boolean bl) throws UnsupportedEncodingException {
        this(outputStream, Encoding.forName(string), bl);
    }

    public XmlWriter(OutputStream outputStream, Encoding encoding, boolean bl) throws UnsupportedEncodingException {
        super(encoding.createWriter(outputStream), bl);
        this.init(encoding);
    }

    public XmlWriter(Writer writer, String string, boolean bl) {
        this(writer, Encoding.forName(string), bl);
    }

    public XmlWriter(Writer writer, Encoding encoding, boolean bl) {
        super(writer, bl);
        this.init(encoding);
    }

    private void init(Encoding encoding) {
        this.encoding_ = encoding;
        this.setLineSeparator(LINE_SEPARATOR);
    }

    public Encoding getEncoding() {
        return this.encoding_;
    }

    public void printAttribute(String string, String string2) {
        this.write(32);
        this.print(string);
        this.write(61, 34);
        this.printAttributeValue(string2);
        this.write(34);
    }

    public synchronized void printAttributeValue(String string) {
        char[] cArray = this.getChars(string);
        int n = string.length();
        int n2 = 0;
        block7: for (int i = 0; i < n; ++i) {
            String string2;
            char c = cArray[i];
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '\n': {
                    string2 = "&#xa;";
                    break;
                }
                default: {
                    continue block7;
                }
            }
            this.write(cArray, n2, i - n2);
            this.print(string2);
            n2 = i + 1;
        }
        this.write(cArray, n2, n - n2);
    }

    public synchronized void printText(String string) {
        char[] cArray = this.getChars(string);
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            String string2 = null;
            if (!this.encoding_.isPrintable(c)) {
                string2 = "&#" + Integer.toString(c) + ';';
            } else {
                switch (c) {
                    case '<': {
                        string2 = "&lt;";
                        break;
                    }
                    case '>': {
                        string2 = "&gt;";
                        break;
                    }
                    case '&': {
                        string2 = "&amp;";
                    }
                }
            }
            if (string2 == null) continue;
            this.write(cArray, n2, i - n2);
            this.print(string2);
            n2 = i + 1;
        }
        this.write(cArray, n2, n - n2);
    }

    public void printSpace() {
        this.write(32);
    }

    public void printOpen() {
        this.write(60);
    }

    public void printOpenSlash() {
        this.write(60, 47);
    }

    public void printClose() {
        this.write(62);
    }

    public void printCloseSlash() {
        this.write(47, 62);
    }

    public void printEqualsQuote() {
        this.write(61, 34);
    }

    public void printQuote() {
        this.write(34);
    }

    private char[] getChars(String string) {
        this.buffer_.setLength(0);
        this.buffer_.append(string);
        return this.buffer_.getBuffer();
    }
}

