/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.build.normal;

import jd.util.TextBuffer;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.model.build.ElementInfo;
import jd.xml.xpath.model.build.ModelBuilder;
import jd.xml.xpath.model.build.ModelLocator;
import jd.xml.xpath.model.build.normal.AttributeNode;
import jd.xml.xpath.model.build.normal.CommentNode;
import jd.xml.xpath.model.build.normal.ComplexElementNode;
import jd.xml.xpath.model.build.normal.CompositeNode;
import jd.xml.xpath.model.build.normal.ElementNode;
import jd.xml.xpath.model.build.normal.LineNumberMap;
import jd.xml.xpath.model.build.normal.PiNode;
import jd.xml.xpath.model.build.normal.RootNode;
import jd.xml.xpath.model.build.normal.TextNode;
import jd.xml.xpath.model.build.normal.TreeNode;

public class NormalModelBuilder
extends ModelBuilder {
    public static final String MODEL_NAME = "normal";
    private RootNode root_;
    private ModelLocator locator_;
    private TreeNode lastChild_;
    private CompositeNode currentParent_;
    private int nextSerialNumber_;
    private LineNumberMap lineNumberMap_;
    private boolean collectLineNumbers_;

    public void startBuild(String string, NodeNamePool nodeNamePool, int n, ModelLocator modelLocator, boolean bl) {
        this.root_ = new RootNode(string, nodeNamePool, n);
        this.currentParent_ = this.root_;
        this.currentNsContext_ = null;
        this.currentNsCount_ = 1;
        this.lastChild_ = null;
        this.nextSerialNumber_ = 1;
        this.collectLineNumbers_ = modelLocator != null && bl;
        if (this.collectLineNumbers_) {
            this.locator_ = modelLocator;
            this.lineNumberMap_ = new LineNumberMap();
        } else {
            this.locator_ = null;
            this.lineNumberMap_ = null;
        }
        this.root_.setSerialNumber(0);
    }

    public XPathRootNode endBuild() {
        if (this.root_ != null) {
            this.root_.setLineNumberMap(this.lineNumberMap_);
        }
        return this.root_;
    }

    public void startElement(ElementInfo elementInfo) {
        if (elementInfo.attrCount > 0 || this.currentNsContext_ != this.currentParent_.getNamespaceContext()) {
            ComplexElementNode complexElementNode = new ComplexElementNode(elementInfo.name, this.currentNsContext_);
            this.startElement(complexElementNode);
            this.nextSerialNumber_ += this.currentNsCount_;
            NamespaceContext.setDeclarationIds(this.currentNsContext_, complexElementNode.getLocalId());
            if (elementInfo.attrCount > 0) {
                if (elementInfo.idValue != null) {
                    this.root_.setIdElement(elementInfo.idValue, complexElementNode);
                }
                AttributeNode[] attributeNodeArray = new AttributeNode[elementInfo.attrCount];
                for (int i = 0; i < elementInfo.attrCount; ++i) {
                    AttributeNode attributeNode = attributeNodeArray[i] = new AttributeNode(elementInfo.attrNames[i], elementInfo.attrValues[i], complexElementNode);
                    attributeNode.setSerialNumber(this.nextSerialNumber_++);
                }
                complexElementNode.setAttributes(attributeNodeArray);
            }
        } else {
            this.startElement(new ElementNode(elementInfo.name));
            this.nextSerialNumber_ += this.currentNsCount_;
        }
        if (this.collectLineNumbers_) {
            int n = this.locator_.getLineNumber();
            if (n < 0) {
                this.collectLineNumbers_ = false;
            } else {
                this.lineNumberMap_.add(this.currentParent_.serialNumber_, n);
            }
        }
    }

    private void startElement(ElementNode elementNode) {
        this.addNode(elementNode);
        this.currentParent_ = elementNode;
        this.lastChild_ = null;
    }

    public void endElement() {
        this.lastChild_ = this.currentParent_;
        this.currentParent_ = this.currentParent_.parent_;
        this.setNamespaceContext(this.currentParent_.getNamespaceContext());
    }

    public void addProcessingInstruction(String string, String string2) {
        this.addNode(new PiNode(string, string2));
    }

    public void addComment(String string) {
        this.addNode(new CommentNode(string));
    }

    public void addUnparsedEntity(String string, String string2) {
        this.root_.addUnparsedEntity(string, string2);
    }

    private void addNode(TreeNode treeNode) {
        treeNode.setSerialNumber(this.nextSerialNumber_++);
        if (this.lastChild_ == null) {
            this.currentParent_.setFirstChild(treeNode);
        } else {
            this.lastChild_.setNextSibling(treeNode);
        }
        this.lastChild_ = treeNode;
    }

    public void addText(TextBuffer textBuffer) {
        this.addNode(new TextNode(textBuffer.toString()));
    }

    public void cleanup() {
        this.root_ = null;
        this.currentNsContext_ = null;
        this.currentParent_ = null;
        this.lastChild_ = null;
    }
}

