/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.object;

import jd.xml.xpath.XPathException;
import jd.xml.xpath.object.Equality;
import jd.xml.xpath.object.Relation;
import jd.xml.xpath.object.XBoolean;
import jd.xml.xpath.object.XNodeSet;
import jd.xml.xpath.object.XNumber;
import jd.xml.xpath.object.XString;

public abstract class XObject {
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_NODESET = 3;
    public static final int TYPE_VARIABLE = 4;
    public static final int TYPES = 5;
    private static final String[] TYPE_NAMES = new String[]{"boolean", "number", "string", "node-set", "variable"};

    public abstract int getType();

    public final String getTypeName() {
        return TYPE_NAMES[this.getType()];
    }

    public static String getTypeName(int n) {
        return TYPE_NAMES[n];
    }

    public abstract Object toValue();

    public abstract Object toValue(Class var1);

    public abstract int canConvertTo(Class var1);

    public abstract boolean toBooleanValue();

    public abstract double toNumberValue();

    public abstract String toStringValue();

    public XNodeSet toNodeSet() throws XPathException {
        throw new XPathException("objects of type " + this.getTypeName() + " cannot be converted to a node set");
    }

    public XObject toXObject(int n) {
        if (n == this.getType()) {
            return this;
        }
        switch (n) {
            case 2: {
                return new XString(this.toStringValue());
            }
            case 1: {
                return new XNumber(this.toNumberValue());
            }
            case 0: {
                return XBoolean.getBoolean(this.toBooleanValue());
            }
            case 3: {
                return this.toNodeSet();
            }
        }
        throw new XPathException("cannot convert to type '" + n + "'");
    }

    public abstract boolean compare(Equality var1, String var2);

    public boolean compare(Equality equality, boolean bl) {
        return equality.compare(this.toBooleanValue(), bl);
    }

    public boolean compare(Equality equality, double d) {
        return equality.compare(this.toNumberValue(), d);
    }

    public boolean compare(Relation relation, double d) {
        return relation.compare(this.toNumberValue(), d);
    }

    public boolean compare(Equality equality, XObject xObject) {
        int n = xObject.getType();
        if (n == 3) {
            return xObject.compare(equality, this);
        }
        switch (Math.min(this.getType(), n)) {
            case 1: {
                return equality.compare(this.toNumberValue(), xObject.toNumberValue());
            }
            case 2: {
                return equality.compare(this.toStringValue(), xObject.toStringValue());
            }
        }
        return equality.compare(this.toBooleanValue(), xObject.toBooleanValue());
    }

    public boolean compare(Relation relation, XObject xObject) {
        return xObject.getType() == 3 ? xObject.toNodeSet().compare(relation.getReverse(), this.toNumberValue()) : relation.compare(this.toNumberValue(), xObject.toNumberValue());
    }

    public int hashCode() {
        return this.toValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof XObject) {
            XObject xObject = (XObject)object;
            if (this.getType() == xObject.getType()) {
                return this.toValue().equals(xObject.toValue());
            }
        }
        return false;
    }

    public String toString() {
        return this.toStringValue();
    }
}

