/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantLargeNumeric;

public class ConstantLongInfo
extends ConstantLargeNumeric {
    public byte getTag() {
        return 5;
    }

    public String getTagVerbose() {
        return "CONSTANT_Long_info";
    }

    public String getVerbose() throws InvalidByteCodeException {
        return String.valueOf(this.getLong());
    }

    public long getLong() {
        return (long)this.highBytes << 32 | (long)this.lowBytes & Integer.MAX_VALUE;
    }

    public void setLong(long l) {
        this.highBytes = (int)(l >>> 32);
        this.lowBytes = (int)(l & 0xFFFFL);
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeByte(5);
        super.write(dataOutput);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + this.getTagVerbose() + " with high_bytes " + this.highBytes + " and low_bytes " + this.lowBytes);
    }
}

