/*
 * asmail is the AfterStep mailbox monitor
 * Copyright (c) 2002 Albert Dorofeev <albert@tigr.net>
 * For the updates see http://www.tigr.net/
 *
 * This software is distributed under GPL. For details see LICENSE file.
 */

#include <pthread.h>
#include "globals.h"
#include <errno.h>

char config_file_name[MAX_INPUT_LENGTH+1] = "";
int flag_verbose = 0;
int flag_allow_insecure = 0;
int flag_no_x = 0;
int flag_no_config = 0;
int flag_config_specified = 0;
struct x11_set_struct x11_set;

struct mbox_struct * mbox = NULL;

pthread_mutex_t update_lock;
pthread_cond_t update_cv;
int update_count = 0;

void signal_update() {
	pthread_mutex_lock(&update_lock);
	++update_count;
	pthread_mutex_unlock(&update_lock);
	/* pthread_cond_signal(&update_cv); */
	pthread_cond_broadcast(&update_cv);
}

int sleep_update( const int msec ) {
	struct timespec tv;
	int result;
	clock_gettime(CLOCK_REALTIME, &tv);
	tv.tv_sec += msec / 100;
	tv.tv_nsec += msec % 100 * 10000000;
	pthread_mutex_lock(&update_lock);
	result = pthread_cond_timedwait(&update_cv, &update_lock, &tv);
	pthread_mutex_unlock(&update_lock);
	if ( result == ETIMEDOUT )
		return 0;
	else
		return 1;
}

pthread_mutex_t md5_lock;

pthread_mutex_t check_lock;
pthread_cond_t check_cv;
int check_count = 0;

void signal_check() {
	pthread_mutex_lock(&check_lock);
	++check_count;
	pthread_mutex_unlock(&check_lock);
	pthread_cond_broadcast(&check_cv);
}

int sleep_check( const int sec ) {
	time_t t;
	struct timespec tv;
	int result;
	time(&t);
	tv.tv_sec = t + sec;
	tv.tv_nsec = 0;
	pthread_mutex_lock(&check_lock);
	result = pthread_cond_timedwait(&check_cv, &check_lock, &tv);
	pthread_mutex_unlock(&check_lock);
	if ( result == ETIMEDOUT )
		return 0;
	else
		return 1;
}

