// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CPrintVisitor_h__
#define __CPrintVisitor_h__

/** \file
 *  CTree based syntax tree printing. */

#include <iostream>
#include "Puma/CVisitor.h"
using namespace std;

namespace Puma {


class CObjectInfo;


/** \class CPrintVisitor CPrintVisitor.h Puma/CPrintVisitor.h
 *  Tree visitor for printing the C/C++ syntax tree. Prints the
 *  indented tree structure supplemented with type information, 
 *  calculated constant values, implicit casts, and resolved 
 *  function calls. */
class CPrintVisitor : private CVisitor {
  ostream *out;
  int indent;

public:
  /** Constructor. */
  CPrintVisitor () : out ((ostream*)0), indent (0) {}
    
  /** Start printing the given tree on the given output stream.
   *  \param tree The syntax tree to print.
   *  \param os The output stream. */
  void print (CTree *tree, ostream &os);

private:
  void pre_visit (CTree *node);
  void post_visit (CTree *node);

  void print_node (CTree *node) const;
  void print_qual_name (CObjectInfo *) const;
};


} // namespace Puma

#endif /* __CPrintVisitor_h__ */
