/* Copyright (C) 2000, 2001, 2002 by SWsoft
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*  $Id: squeue.cpp,v 1.47 2002/04/20 11:09:26 al Exp $
    Author : Alexander F. Avdonkin
	Implemented classes: CSiteUrls, CSitesQueue, CMySQLDatabaseI
*/

#include <sys/time.h>
#include "squeue.h"
#include "charsets.h"
#include "sqldb.h"
#include "parse.h"
#include "hrefs.h"
#include "rank.h"
#include "index.h"
#include "config.h"
#include "logger.h"
#include "lastmod.h"
//#include "geo.h"

hash_set<CURLName> Sites;
CMapStringToStringVec Robots;
int max_failed_current = 10;

void CSiteUrls::SetLastAccess()
{
	if (m_minDelay)
	{
		gettimeofday(&m_lastAccess, NULL);
	}
}

int CSiteUrls::WillBeReady()
{
	if (m_minDelay)
	{
		double d;
		struct timeval tm;
		gettimeofday(&tm, NULL);
		d = m_minDelay - timedif(tm, m_lastAccess);
		return d > 0 ? (int)(d * 1000) + 1 : 0;
	}
	else
	{
		return 0;
	}
}

void CSitesQueue::Insert(CSiteUrls* urls, CSiteUrls*& current)
{
	if (current == NULL)
	{
		current = urls;
		urls->m_next = urls;
		urls->m_prev = urls;
	}
	else
	{
		urls->m_next = current;
		urls->m_prev = current->m_prev;
		current->m_prev->m_next = urls;
		current->m_prev = urls;
	}
}

void CSitesQueue::Insert(CSiteUrls* urls)
{
	Insert(urls, m_current);
}

void CSitesQueue::AddURL(ULONG site_id, ULONG url_id, CSQLDatabase* database)
{
	CSiteUrls* urls;
	iterator it = find(site_id);
	if (it == end())
	{
		CServer* srv=NULL;
		char site[300];
		if (database->GetSite(site_id, site)) srv = FindServer(site);
		urls = &(*this)[site_id];
		urls->m_siteID = site_id;
		if (srv)
		{
			urls->m_minDelay = srv->m_minDelay;
			urls->m_maxDocs = srv->m_maxDocs;
		}
		m_inactiveSize++;
		Insert(urls);
	}
	else
	{
		urls = &it->second;
		if ((urls->m_count == 0) && (urls->m_state == 0))
		{
			m_inactiveSize++;
			m_failedConns += urls->m_connFailed;
			Insert(urls, urls->m_connFailed ? m_currentFail : m_current);
		}
	}
	urls->Insert(url_id);
	m_qDocs++;
}

void CSitesQueue::AddURL(ULONG site_id, ULONG url_id, const char* url)
{
	CSiteUrls* urls;
	iterator it = find(site_id);
	if (it == end())
	{
		CServer* srv;
		srv = url ? FindServer(url) : NULL;
		urls = &(*this)[site_id];
		urls->m_siteID = site_id;
		if (srv)
		{
			urls->m_minDelay = srv->m_minDelay;
			urls->m_maxDocs = srv->m_maxDocs;
		}
		m_inactiveSize++;
		Insert(urls);
	}
	else
	{
		urls = &it->second;
		if ((urls->m_count == 0) && (urls->m_state == 0))
		{
			m_inactiveSize++;
			m_failedConns += urls->m_connFailed;
			Insert(urls, urls->m_connFailed ? m_currentFail : m_current);
		}
	}
	urls->Insert(url_id);
	m_qDocs++;
}

ULONG CSitesQueue::ExtractURL()
{
	int f = (m_currentFail && (m_failedProcessed < max_failed_current)) || (m_current == NULL);
	CSiteUrls*& current = f ? m_currentFail : m_current;
	if (current)
	{
		int ms;
		if ((ms = current->WillBeReady()) != 0)
		{
			current = current->m_next;
			return ~0;
		}
		CSiteUrls* urls = current->Remove();
		current = current->m_next == current ? NULL : current->m_next;
		m_inactiveSize--;
		m_activeSize++;
		urls->m_state = 1;
		if (f)
		{
			m_failedProcessed++;
		}
		return urls->RemoveFirst();
	}
	else
	{
		return 0;
	}
}

void CSitesQueue::DeleteURL(ULONG siteID, int index_result)
{
	CSiteUrls& urls = (*this)[siteID];
	m_activeSize--;
	urls.m_state = 0;
	int lastFailed = urls.m_connFailed;
	urls.m_connFailed = (index_result == NET_CANT_CONNECT) || (index_result == NET_CANT_RESOLVE) ? 1 : 0;
	if (urls.m_count != 0)
	{
		m_inactiveSize++;
		m_failedConns += (urls.m_connFailed - lastFailed);
		CSiteUrls*& current = urls.m_connFailed ? m_currentFail : m_current;
		if ((++urls.m_docCnt >= urls.m_maxDocs) || (index_result < 0))
		{
			urls.m_docCnt = 0;
			Insert(&urls, current);
		}
		else
		{
			Insert(&urls, current);
			current = current->m_prev;
		}
	}
	else
	{
		m_failedConns -= lastFailed;
//		urls.m_connFailed = 0;
	}
	m_failedProcessed -= lastFailed;
	urls.SetLastAccess();
	m_qDocs--;
}

