/*
 * (CAPI*)
 *
 * An implementation of Common ISDN API 2.0 for Asterisk
 *
 * RETRIEVE
 *
 * Copyright (C) 2002, Junghanns.NET GmbH
 *
 * Klaus-Peter Junghanns <kapejod@ns1.jnetdns.de>
 *
 * This program is free software and may be modified and 
 * distributed under the terms of the GNU Public License.
 */

#include <asterisk/file.h>
#include <asterisk/logger.h>
#include <asterisk/channel.h>
#include <asterisk/channel_pvt.h>
#include <asterisk/pbx.h>
#include <asterisk/module.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <pthread.h>
#include <linux/capi.h>
#include <capi20.h>
#include "chan_capi_pvt.h"
#include "chan_capi_app.h"



static char *tdesc = "(CAPI*) RETRIEVE";
static char *app = "capiRETRIEVE";
static char *synopsis = "retrieve the call that is on hold";

STANDARD_LOCAL_USER;

LOCAL_USER_DECL;

static int capiRETRIEVE_exec(struct ast_channel *chan, void *data)
{
    struct ast_capi_pvt *i = chan->pvt->pvt;
    MESSAGE_EXCHANGE_ERROR Info;
    _cmsg	CMSG/*,*CMSG2*/;
    char	fac[4];
    int res=0;
    struct localuser *u;

    LOCAL_USER_ADD(u);
    /* Do our thing here */

//    if ((i->state != CAPI_STATE_ONHOLD) || (i->onholdPLCI <= 0)) {
    if (i->onholdPLCI <= 0) {
    	ast_log(LOG_WARNING, "no call on hold to retrieve!\n");
	return -1;
    }

    fac[0] = 3;	// len
    fac[1] = 0x03; // retrieve
    fac[2] = 0x00;
    fac[3] = 0;	

    FACILITY_REQ_HEADER(&CMSG,ast_capi_ApplID,ast_capi_MessageNumber++,0);
    FACILITY_REQ_PLCI(&CMSG) = i->onholdPLCI;
    FACILITY_REQ_FACILITYSELECTOR(&CMSG) = 0x0003; // sservices
    FACILITY_REQ_FACILITYREQUESTPARAMETER(&CMSG) = (char *)&fac;

    if ((Info = _capi_put_cmsg(&CMSG)) != 0) {
	ast_log(LOG_ERROR,"Error sending FACILITY_REQ\n");
	return Info;
    } else {
	i->state = CAPI_STATE_RETRIEVING;
	ast_log(LOG_NOTICE,"sent FACILITY_REQ PLCI = %#x\n",i->onholdPLCI);
    }

    while (i->state == CAPI_STATE_RETRIEVING) {
	usleep(10000);
    }


    // send a CONNECT_B3_REQ
    memset(&CMSG,0,sizeof(_cmsg));
    CONNECT_B3_REQ_HEADER(&CMSG, ast_capi_ApplID, ast_capi_MessageNumber++,0);
    CONNECT_B3_REQ_PLCI(&CMSG) = i->PLCI;
    if ((Info = _capi_put_cmsg(&CMSG)) != 0) {
        ast_log(LOG_ERROR,"error sending CONNECT_B3_REQ (error=%#x)\n",Info);
    } else {
        ast_log(LOG_NOTICE,"sent CONNECT_B3_REQ (PLCI=%#x)\n",i->PLCI);
    }

    while (i->state == CAPI_STATE_CONNECTED) {
	usleep(10000);
    }
    ast_log(LOG_NOTICE,"retrieved PLCI = %#x\n",i->PLCI);
    
    LOCAL_USER_REMOVE(u);
    return res;
}

int unload_module(void)
{
	STANDARD_HANGUP_LOCALUSERS;
	return ast_unregister_application(app);
}

int load_module(void)
{
	return ast_register_application(app, capiRETRIEVE_exec,synopsis,tdesc);
}

char *description(void)
{
	return tdesc;
}

int usecount(void)
{
	int res;
	STANDARD_USECOUNT(res);
	return res;
}

char *key()
{
	return ASTERISK_GPL_KEY;
}
