#include <stdio.h>
#include <string.h>
/*#include <readline/readline.h>
  #include <readline/history.h> */
#include "te_lib.h"

int misdn_debug = 2;

void myEvent(manager_te_t *mgr, enum te_event_e event, bchannel_te_t *bc, void *user_data)
{
  printf("Event_Ind:%s with bc: %x and pid %d and cr %x mode %s port %d\n",manager_isdn_get_info( event),bc->addr & IF_ADDRMASK, bc->cr?bc->cr->pid:-1, bc->cr?bc->cr->l3_id:-1, bc->stack->mode==NT_MODE?"NT":"TE", bc->stack->port);
  
  
  switch (event) {
  case EVENT_SETUP:
    printf("--> oad %s dad %s channel %d\n",bc->oad,bc->dad, bc->channel);
    
    if (bc->stack->mode == NT_MODE) 
      manager_te_send_event(mgr, bc, EVENT_SETUP_ACKNOWLEDGE );
    
    //manager_bchannel_activate(bc);
    //manager_ph_control(bc, TONE_PATT_ON, TONE_GERMAN_DIALTONE);
    break;
  case EVENT_INFORMATION:
    printf("--> info_dad %s channel %d\n",bc->info_dad, bc->channel);
    break;
  case EVENT_ALERTING:
    //manager_ph_control(bc, TONE_PATT_ON, TONE_GERMAN_RINGING);
    break;
  case EVENT_RELEASE:
    //manager_bchannel_deactivate(bc);
    //manager_ph_control(bc, TONE_PATT_OFF, TONE_OFF);
    manager_te_send_event(mgr, bc, EVENT_RELEASE_COMPLETE );
    break;
  case EVENT_CONNECT:
    manager_te_send_event(mgr, bc, EVENT_CONNECT_ACKNOWLEDGE );
  case EVENT_CONNECT_ACKNOWLEDGE:
    bc->state=STATE_CONNECTED;
    break;
  case EVENT_DISCONNECT:
    //manager_bchannel_deactivate(bc);
    manager_te_send_event(mgr,bc,EVENT_RELEASE);
    break;
  case EVENT_BCHAN_DATA:
    //printf("Got B-Data\n");
    break;
  default:
    break;
  }
}

int main ( int argc, char **argv ) {
  char buf[256];
  //char *buf;
  manager_te_t* mgr;
  int i;
  int defport;

  defport= (argc==2?atoi(argv[1]):1);
  
  msg_init();
  
  mgr=manager_te_init(argc==2?argv[1]:"1", myEvent, NULL);
  
  if (!mgr) exit(1);
  
  while(1) {

    
    i=read(0,buf,256);
    buf[i]=0;
    //buf = readline(">");

    if (!buf) {
      printf("Didn't get anything ?\n");
      continue;
    }
    
    if (strstr(buf,"ata")) {
      char *p=buf;
      int pid;
      p+=3;
      pid=atoi(p);
      
      printf("Sending Connect to pid %d\n",pid);
      {
	bchannel_te_t *bc = manager_find_bc_by_pid(mgr, pid);
	if (!bc) continue;
	
	manager_te_send_event(mgr, bc, EVENT_CONNECT );
      }
      
    } else if (strstr(buf,"ath")) {
      char *p=buf;
      int pid;
      p +=3;
      pid=atoi(p);
      
      printf("Sending Hangup to pid %d\n",pid);
      
      {
	bchannel_te_t *bc = manager_find_bc_by_pid(mgr, pid);
	if (!bc) continue;
	if (bc->state == STATE_CONNECTED) {
	  //bc->cr->l3_id; // = bc->cr->ces | (bc->cr->l3_id << 16);
	  manager_te_send_event(mgr, bc, EVENT_DISCONNECT );
	  //manager_te_send_event(mgr, bc, EVENT_RELEASE );
	}
	else {
	  manager_te_send_event(mgr, bc, EVENT_RELEASE_COMPLETE );
	}
	
	bc->state=STATE_NOTHING;
      }
      
      
    } else if (strstr(buf,"atd")) {
      bchannel_te_t *newbc=NULL;
      int port;
      char *num;
      char *p=buf;
      char *p2=strchr(buf,'\n');
      char *tok1,*tok2, delim[]=", #";
      if (p2) *p2=0;
      p+=3;
      
      tok1=strtok_r(p,delim,&p2);
      if (tok1) tok2=strtok_r(NULL,delim,&p2);
      
      if (!tok2) {
	port=defport;
	num=tok1;
      }
      else {
	port=atoi(tok1);
	num=tok2;
      }
      
      newbc=manager_te_get_free_bc(mgr, port );
      if (!newbc) {
	printf("No free channel\n");
	continue;
      }
      strcpy(newbc->dad,num);
      strcpy(newbc->oad,"43");
      manager_te_send_event(mgr, newbc, EVENT_SETUP );      
      
    } else if (strstr(buf,"ats")) {
      stack_te_t *stack;
      printf("BEGIN STACK_LIST:\n");
      for (stack=mgr->stack_list;
	   stack;
	   stack=stack->next ) {
	int i;
	printf("* Stack Addr: Uid %x Port %d \n",stack->upper_id, stack->upper_id & IF_CONTRMASK);
	for (i=0; i< stack->b_num; i++) {
	  bchannel_te_t *mybc=&stack->bc_te[i];
	  printf(" --> bchan: b_addr %x addr %x l3Id %x channel %d pid %d\n",mybc->b_addr, mybc->addr, mybc->cr?mybc->cr->l3_id:-1, mybc->channel, mybc->cr?mybc->cr->pid:-1);
	}
      }
      printf("END\n");
    } else if (strstr(buf,"atp")) {
      stack_te_t *stack;
      printf("BEGIN CR_LIST:\n");
      for (stack=mgr->stack_list;
	   stack;
	   stack=stack->next ) {
	cr_list_t *cr;
	printf("* Stack Port: %d\n",stack->upper_id&IF_CONTRMASK);
	for (cr=stack->cr_list;
	     cr;
	     cr=cr->next) 
	  printf(" --> cr: cr->l3id %x cr->pid %d cr->bc %p \n", cr->l3_id, cr->pid, cr->bc);
	
      }
      printf("END\n");
      
    } else if (strstr(buf,"send")) {
      char *p=strchr(buf,' ');
      int pid; 
      bchannel_te_t *bc;
      if (!p) continue;
      p++;
      pid=atoi(p);
      bc = manager_find_bc_by_pid(mgr, pid);
      p=strchr(p,' ');
      if (!p) continue;
      p++;
      strcpy(bc->display,p);
      manager_te_send_event(mgr, bc, EVENT_INFORMATION);
      
    } else if (strstr(buf, "fork")) {
      int pid;
      printf("forking..\n");
      
      pid=fork();

      if (!pid) {
	while(1);
      }
      
    } else if (strstr(buf, "quit")) {
      printf("Quitting..\n");
      te_lib_destroy(mgr->midev);
      exit(0);
    } else {
      printf("Unknown Command\n");
    }
    //free(buf);
  }
  
}

void chan_misdn_log(char *tmpl, ...)
{
  va_list ap;
  
  va_start(ap, tmpl);
  
  vprintf(  tmpl, ap );
  
  va_end(ap);
}
