#include <stdio.h>
#include <string.h>
/*#include <readline/readline.h>
  #include <readline/history.h> */
#include "te_lib.h"

int misdn_debug = 2;

void myEvent(misdn_lib_t *mgr, enum te_event_e event, struct misdn_bchannel *bc, void *user_data)
{
  printf("Event_Ind:%s and  mode %s port %d\n",manager_isdn_get_info( event), bc->stack->mode==NT_MODE?"NT":"TE", bc->stack->port);
  
  
  switch (event) {
  case EVENT_SETUP:
    printf("--> oad %s dad %s channel %d\n",bc->oad,bc->dad, bc->channel);
    
    if (bc->stack->mode == NT_MODE) 
      misdn_lib_send_event(mgr, bc, EVENT_SETUP_ACKNOWLEDGE );
    
    /* manager_bchannel_activate(bc); */
    /* manager_ph_control(bc, TONE_PATT_ON, TONE_GERMAN_DIALTONE); */
    break;
  case EVENT_INFORMATION:
    printf("--> info_dad %s channel %d\n",bc->info_dad, bc->channel);
    break;
  case EVENT_ALERTING:
    /* manager_ph_control(bc, TONE_PATT_ON, TONE_GERMAN_RINGING); */
    break;
  case EVENT_RELEASE:
    /* manager_bchannel_deactivate(bc); */
    /* manager_ph_control(bc, TONE_PATT_OFF, TONE_OFF); */
    misdn_lib_send_event(mgr, bc, EVENT_RELEASE_COMPLETE );
    break;
  case EVENT_CONNECT:
    misdn_lib_send_event(mgr, bc, EVENT_CONNECT_ACKNOWLEDGE );
  case EVENT_CONNECT_ACKNOWLEDGE:
    bc->state=STATE_CONNECTED;
    break;
  case EVENT_DISCONNECT:
    /* manager_bchannel_deactivate(bc); */
    misdn_lib_send_event(mgr,bc,EVENT_RELEASE);
    break;
  case EVENT_BCHAN_DATA:
    /* printf("Got B-Data\n"); */
    break;
  default:
    break;
  }
}

int main ( int argc, char **argv ) {
  char buf[256];
  /* char *buf; */
  misdn_lib_t* mgr;
  int i;
  int defport;

  i = mISDN_open();
  if (i<0) {
    perror("Open of mISDN Failed\n");
    exit(1);
  }
  mISDN_close(i);
  
  
  defport= (argc==2?atoi(argv[1]):1);

  msg_init();
  debug_init( 0xffffffff & ~DBGM_MSG, NULL, NULL, NULL);
  
  
  mgr=misdn_lib_init(argc==2?argv[1]:"1", myEvent, NULL);
  
  if (!mgr) exit(1);
  
  while(1) {

    
    i=read(0,buf,256);
    buf[i]=0;
    /* buf = readline(">"); */

    if (!buf) {
      printf("Didn't get anything ?\n");
      continue;
    }
    
    if (strstr(buf,"ata")) {
      char *p=buf;
      int pid;
      p+=3;
      pid=atoi(p);
      
      printf("Sending Connect to pid %d\n",pid);
      {
	struct misdn_bchannel *bc = manager_find_bc_by_pid(mgr, pid);
	if (!bc) continue;
	
	misdn_lib_send_event(mgr, bc, EVENT_CONNECT );
      }
      
    } else if (strstr(buf,"ath")) {
      char *p=buf;
      int pid;
      p +=3;
      pid=atoi(p);
      
      printf("Sending Hangup to pid %d\n",pid);
      
      {
	struct misdn_bchannel *bc = manager_find_bc_by_pid(mgr, pid);
	if (!bc) continue;
	if (bc->state == STATE_CONNECTED) {
	  /* bc->cr->l3_id; /* = bc->cr->ces | (bc->cr->l3_id << 16); */
	  misdn_lib_send_event(mgr, bc, EVENT_DISCONNECT );
	  /* misdn_lib_send_event(mgr, bc, EVENT_RELEASE ); */
	}
	else {
	  misdn_lib_send_event(mgr, bc, EVENT_RELEASE_COMPLETE );
	}
	
	bc->state=STATE_NOTHING;
      }
      
      
    } else if (strstr(buf,"atd")) {
      struct misdn_bchannel *newbc=NULL;
      int port;
      char *num;
      char *p=buf;
      char *p2=strchr(buf,'\n');
      char *tok1,*tok2, delim[]=", #";
      if (p2) *p2=0;
      p+=3;
      
      tok1=strtok_r(p,delim,&p2);
      if (tok1) tok2=strtok_r(NULL,delim,&p2);
      
      if (!tok2) {
	port=defport;
	num=tok1;
      }
      else {
	port=atoi(tok1);
	num=tok2;
      }
      
      newbc=misdn_lib_get_free_bc(mgr, port );
      if (!newbc) {
	printf("No free channel\n");
	continue;
      }
      strcpy(newbc->dad,num);
      strcpy(newbc->oad,"43");
      misdn_lib_send_event(mgr, newbc, EVENT_SETUP );      
      
    } else if (strstr(buf,"ats")) {
      misdn_stack_t *stack;
      printf("BEGIN STACK_LIST:\n");
      for (stack=mgr->stack_list;
	   stack;
	   stack=stack->next ) {
	int i;
	printf("* Stack Addr: Uid %x Port %d \n",stack->upper_id, stack->upper_id & IF_CONTRMASK);
	for (i=0; i< stack->b_num; i++) {
	  struct misdn_bchannel *mybc=&stack->bc_te[i];
	  printf(" --> bchan: addr %x addr %x  channel %d\n",mybc->addr, mybc->addr, mybc->channel );
	}
      }
      printf("END\n");
    } else if (strstr(buf,"atp")) {
      misdn_stack_t *stack;
      printf("BEGIN CR_LIST:\n");
      for (stack=mgr->stack_list;
	   stack;
	   stack=stack->next ) {
      }
      printf("END\n");
      
    } else if (strstr(buf,"send")) {
      char *p=strchr(buf,' ');
      int pid; 
      struct misdn_bchannel *bc;
      if (!p) continue;
      p++;
      pid=atoi(p);
      bc = manager_find_bc_by_pid(mgr, pid);
      p=strchr(p,' ');
      if (!p) continue;
      p++;
      strcpy(bc->display,p);
      misdn_lib_send_event(mgr, bc, EVENT_INFORMATION);
      
    } else if (strstr(buf, "fork")) {
      int pid;
      printf("forking..\n");
      
      pid=fork();

      if (!pid) {
	while(1);
      }
      
    } else if (strstr(buf, "quit")) {
      printf("Quitting..\n");
      te_lib_destroy(mgr->midev);
      exit(0);
    } else {
      printf("Unknown Command\n");
    }
    /* free(buf); */
  }
  
}

void chan_misdn_log(char *tmpl, ...)
{
  va_list ap;
  
  va_start(ap, tmpl);
  
  vprintf(  tmpl, ap );
  
  va_end(ap);
}
