/***** Autogenerated from runtime.in *****/
/*****
 * runtime.in
 * Tom Prince 2005/4/15
 *
 * Generate runtime functions.
 *
 *****/

#include "angle.h"
#include "pair.h"
#include "triple.h"
#include "transform.h"
#include "path.h"
#include "pen.h"
#include "guide.h"
#include "picture.h"
#include "drawpath.h"
#include "drawfill.h"
#include "drawclipbegin.h"
#include "drawclipend.h"
#include "drawlabel.h"
#include "drawverbatim.h"
#include "drawgsave.h"
#include "drawgrestore.h"
#include "drawlayer.h"
#include "drawimage.h"
#include "drawgroup.h"
#include "fileio.h"
#include "genv.h"
#include "builtin.h"
#include "texfile.h"
#include "pipestream.h"
#include "parser.h"
#include "stack.h"
#include "util.h"
#include "mathop.h"
#include "callable.h"
  
using namespace vm;
using namespace camp;
using namespace settings;

namespace run {
using camp::pair;
using mem::string;

callable *atExitFunction=NULL;
callable *atDrawFunction=NULL;
}

using namespace types;

static inline int Round(double x) 
{
  return int(x+((x >= 0) ? 0.5 : -0.5));
}

function *voidFunction()
{
  function *ft = new function(primVoid());
  return ft;
}



namespace run {

void gen0__label(vm::stack *gen_theStack)
{
  pen * p = vm::pop<pen *>(gen_theStack);
  pair scale = vm::pop<pair>(gen_theStack);
  pair a = vm::pop<pair>(gen_theStack);
  pair z = vm::pop<pair>(gen_theStack);
  double r = vm::pop<double>(gen_theStack);
  string * size = vm::pop<string *>(gen_theStack);
  string * s = vm::pop<string *>(gen_theStack);
  picture * pic = vm::pop<picture *>(gen_theStack);

  pic->append(new drawLabel(*s,*size,r,z,a,scale,p));
}

void gen1_labels(vm::stack *gen_theStack)
{
  picture * pic = vm::pop<picture *>(gen_theStack);

  { gen_theStack->push<bool>(pic->havelabels()); return; }
}

void gen2_basealign(vm::stack *gen_theStack)
{
  int n = vm::pop<int>(gen_theStack);

  { gen_theStack->push<pen*>(new pen(n >= 0 && n < nBaseLine 
                   ? (BaseLine) n
                   : DEFBASE)); return; }
}

void gen3_draw(vm::stack *gen_theStack)
{
  pen * n = vm::pop<pen *>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);
  picture * pic = vm::pop<picture *>(gen_theStack);

  pic->append(new drawPath(p,*n));
}

void gen4_endclip(vm::stack *gen_theStack)
{
  picture * pic = vm::pop<picture *>(gen_theStack);

  pic->append(new drawClipEnd(false));
}

void gen5_gsave(vm::stack *gen_theStack)
{
  picture * pic = vm::pop<picture *>(gen_theStack);

  pic->append(new drawGsave());
}

void gen6_grestore(vm::stack *gen_theStack)
{
  picture * pic = vm::pop<picture *>(gen_theStack);

  pic->append(new drawGrestore());
}

void gen7_begingroup(vm::stack *gen_theStack)
{
  picture * pic = vm::pop<picture *>(gen_theStack);

  pic->append(new drawBegin());
}

void gen8_endgroup(vm::stack *gen_theStack)
{
  picture * pic = vm::pop<picture *>(gen_theStack);

  pic->append(new drawEnd());
}

void gen9_add(vm::stack *gen_theStack)
{
  picture * from = vm::pop<picture *>(gen_theStack);
  picture * to = vm::pop<picture *>(gen_theStack);

  to->add(*from);
}

void gen10_prepend(vm::stack *gen_theStack)
{
  picture * from = vm::pop<picture *>(gen_theStack);
  picture * to = vm::pop<picture *>(gen_theStack);

  to->prepend(*from);
}

void gen11_fileprefix(vm::stack *gen_theStack)
{

  { gen_theStack->push<string>(outname); return; }
}

// Interactive mode
void gen12_interact(vm::stack *gen_theStack)
{

  { gen_theStack->push<bool>(interact::interactive); return; }
}

void gen13_uptodate(vm::stack *gen_theStack)
{
  bool b = vm::pop<bool>(gen_theStack);

  interact::uptodate=b;
}

void gen14_uptodate(vm::stack *gen_theStack)
{

  { gen_theStack->push<bool>(interact::uptodate); return; }
}

// System commands
void gen15_system(vm::stack *gen_theStack)
{
  string * str = vm::pop<string *>(gen_theStack);

  if(safe) error("system() call disabled; override with option -unsafe");
  else { gen_theStack->push<int>(System(str->c_str())); return; }
}

void gen16_abort(vm::stack *gen_theStack)
{
  string * msg = vm::pop<string *>(gen_theStack);

  error(msg->c_str());
}

// Path operations
void gen17_point(vm::stack *gen_theStack)
{
  int n = vm::pop<int>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(p.point(n)); return; }
}

void gen18_point(vm::stack *gen_theStack)
{
  double t = vm::pop<double>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(p.point(t)); return; }
}

void gen19_precontrol(vm::stack *gen_theStack)
{
  int n = vm::pop<int>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(p.precontrol(n)); return; }
}

void gen20_precontrol(vm::stack *gen_theStack)
{
  double t = vm::pop<double>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(p.precontrol(t)); return; }
}

void gen21_postcontrol(vm::stack *gen_theStack)
{
  int n = vm::pop<int>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(p.postcontrol(n)); return; }
}

void gen22_postcontrol(vm::stack *gen_theStack)
{
  double t = vm::pop<double>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(p.postcontrol(t)); return; }
}

void gen23_dir(vm::stack *gen_theStack)
{
  int n = vm::pop<int>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(unit(p.direction(n))); return; }
}

void gen24_dir(vm::stack *gen_theStack)
{
  double t = vm::pop<double>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(unit(p.direction(t))); return; }
}

void gen25_reverse(vm::stack *gen_theStack)
{
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<path>(p.reverse()); return; }
}

void gen26_subpath(vm::stack *gen_theStack)
{
  int e = vm::pop<int>(gen_theStack);
  int b = vm::pop<int>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<path>(p.subpath(b,e)); return; }
}

void gen27_subpath(vm::stack *gen_theStack)
{
  double e = vm::pop<double>(gen_theStack);
  double b = vm::pop<double>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<path>(p.subpath(b,e)); return; }
}

void gen28_length(vm::stack *gen_theStack)
{
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<int>(p.length()); return; }
}

void gen29_cyclic(vm::stack *gen_theStack)
{
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<bool>(p.cyclic()); return; }
}

void gen30_straight(vm::stack *gen_theStack)
{
  int i = vm::pop<int>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<bool>(p.straight(i)); return; }
}

void gen31_arclength(vm::stack *gen_theStack)
{
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<double>(p.arclength()); return; }
}

void gen32_arctime(vm::stack *gen_theStack)
{
  double dval = vm::pop<double>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<double>(p.arctime(dval)); return; }
}

void gen33_dirtime(vm::stack *gen_theStack)
{
  pair z = vm::pop<pair>(gen_theStack);
  path p = vm::pop<path>(gen_theStack);

  { gen_theStack->push<double>(p.directiontime(z)); return; }
}

void gen34_intersect(vm::stack *gen_theStack)
{
  double fuzz = vm::pop<double>(gen_theStack);
  path y = vm::pop<path>(gen_theStack);
  path x = vm::pop<path>(gen_theStack);

  { gen_theStack->push<pair>(intersectiontime(x,y,fuzz)); return; }
}

// Triple operations
void gen35_cubiclength(vm::stack *gen_theStack)
{
  double goal = vm::pop<double>(gen_theStack);
  triple z1 = vm::pop<triple>(gen_theStack);
  triple z1m = vm::pop<triple>(gen_theStack);
  triple z0p = vm::pop<triple>(gen_theStack);
  triple z0 = vm::pop<triple>(gen_theStack);

  { gen_theStack->push<double>(cubiclength(z0,z0p,z1m,z1,goal)); return; }
}

void gen36_expi(vm::stack *gen_theStack)
{
  double phi = vm::pop<double>(gen_theStack);
  double theta = vm::pop<double>(gen_theStack);

  { gen_theStack->push<triple>(expi(theta,phi)); return; }
  double sintheta=sin(theta);
  { gen_theStack->push<triple>(triple(sintheta*cos(phi),sintheta*sin(phi),cos(theta))); return; }
}

void gen37_dir(vm::stack *gen_theStack)
{
  double phi = vm::pop<double>(gen_theStack);
  double theta = vm::pop<double>(gen_theStack);

  { gen_theStack->push<triple>(expi(radians(theta),radians(phi))); return; }
}

// String operations
void gen38_length(vm::stack *gen_theStack)
{
  string * s = vm::pop<string *>(gen_theStack);

  { gen_theStack->push<int>((int) s->length()); return; }
}

void gen39_find(vm::stack *gen_theStack)
{
  int pos = vm::pop<int>(gen_theStack);
  string * sub = vm::pop<string *>(gen_theStack);
  string * s = vm::pop<string *>(gen_theStack);

  { gen_theStack->push<int>((int) s->find(*sub,pos)); return; }
}

void gen40_rfind(vm::stack *gen_theStack)
{
  int pos = vm::pop<int>(gen_theStack);
  string * sub = vm::pop<string *>(gen_theStack);
  string * s = vm::pop<string *>(gen_theStack);

  { gen_theStack->push<int>((int) s->rfind(*sub,pos)); return; }
}

void gen41_reverse(vm::stack *gen_theStack)
{
  string s = vm::pop<string>(gen_theStack);

  reverse(s.begin(),s.end());
  { gen_theStack->push<string>(s); return; }
}

void gen42_insert(vm::stack *gen_theStack)
{
  string * sub = vm::pop<string *>(gen_theStack);
  int pos = vm::pop<int>(gen_theStack);
  string s = vm::pop<string>(gen_theStack);

  if ((size_t)pos < s.length())
    { gen_theStack->push<string>(s.insert(pos,*sub)); return; }
  { gen_theStack->push<string>(s); return; }
}

void gen43_substr(vm::stack *gen_theStack)
{
  int n = vm::pop<int>(gen_theStack);
  int pos = vm::pop<int>(gen_theStack);
  string* s = vm::pop<string*>(gen_theStack);

  if ((size_t)pos < s->length())
    { gen_theStack->push<string>(s->substr(pos,n)); return; }
  { gen_theStack->push<string>(""); return; } // TODO: Make this shared again.
}

void gen44_erase(vm::stack *gen_theStack)
{
  int n = vm::pop<int>(gen_theStack);
  int pos = vm::pop<int>(gen_theStack);
  string s = vm::pop<string>(gen_theStack);

  if ((size_t)pos < s.length())
    { gen_theStack->push<string>(s.erase(pos,n)); return; }
  { gen_theStack->push<string>(s); return; } 
}

void gen45_gui(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);
 
  settings::deconstruct=(x > 0 ? x : 0);
}

// Math
void gen46_ceil(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);
 
  double y=ceil(x);
  checkint(y,0);
  { gen_theStack->push<int>((int) y); return; }
}

void gen47_floor(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);
 
  double y=floor(x);
  checkint(y,0);
  { gen_theStack->push<int>((int) y); return; }
}

void gen48_round(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);
 
  if(fabs(x) >= INT_MAX+0.5) integeroverflow(0);
  { gen_theStack->push<int>(Round(x)); return; }
}

void gen49_Ceil(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);
 
  { gen_theStack->push<int>(Ceil(x)); return; }
}

void gen50_Floor(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);
 
  { gen_theStack->push<int>(Floor(x)); return; }
}

void gen51_Round(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);
 
  { gen_theStack->push<int>(Round(intcap(x))); return; }
}

void gen52_erf(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);

  { gen_theStack->push<double>(erf(x)); return; }
}

void gen53_erfc(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);

  { gen_theStack->push<double>(erfc(x)); return; }
}

void gen54_gamma(vm::stack *gen_theStack)
{
  double x = vm::pop<double>(gen_theStack);

#ifdef HAVE_TGAMMA
  { gen_theStack->push<double>(tgamma(x)); return; }
#else
 double lg = lgamma(x);
 { gen_theStack->push<double>(signgam*exp(lg)); return; }
#endif
}

void gen55_VERSION(vm::stack *gen_theStack)
{

  { gen_theStack->push<string>(VERSION); return; }
}

void gen56_quiet(vm::stack *gen_theStack)
{
  bool v = vm::pop<bool>(gen_theStack);

  settings::view=!v;
}

void gen57_atexit(vm::stack *gen_theStack)
{
  callable * f = vm::pop<callable *>(gen_theStack);

  atExitFunction=f;
}

void gen58_atexit(vm::stack *gen_theStack)
{

  { gen_theStack->push<callable*>(atExitFunction); return; }
}

} // namespace run

namespace trans {

void gen_base_venv(venv &ve)
{
  addFunc(ve, run::gen0__label, primVoid(), "_label", primPicture(), primString(), primString(), primReal(), primPair(), primPair(), primPair(), primPen());
  addFunc(ve, run::gen1_labels, primBoolean(), "labels", primPicture());
  addFunc(ve, run::gen2_basealign, primPen(), "basealign", primInt());
  addFunc(ve, run::gen3_draw, primVoid(), "draw", primPicture(), primPath(), primPen());
  addFunc(ve, run::gen4_endclip, primVoid(), "endclip", primPicture());
  addFunc(ve, run::gen5_gsave, primVoid(), "gsave", primPicture());
  addFunc(ve, run::gen6_grestore, primVoid(), "grestore", primPicture());
  addFunc(ve, run::gen7_begingroup, primVoid(), "begingroup", primPicture());
  addFunc(ve, run::gen8_endgroup, primVoid(), "endgroup", primPicture());
  addFunc(ve, run::gen9_add, primVoid(), "add", primPicture(), primPicture());
  addFunc(ve, run::gen10_prepend, primVoid(), "prepend", primPicture(), primPicture());
  addFunc(ve, run::gen11_fileprefix, primString() , "fileprefix");
  addFunc(ve, run::gen12_interact, primBoolean(), "interact");
  addFunc(ve, run::gen13_uptodate, primVoid(), "uptodate", primBoolean());
  addFunc(ve, run::gen14_uptodate, primBoolean(), "uptodate");
  addFunc(ve, run::gen15_system, primInt(), "system", primString());
  addFunc(ve, run::gen16_abort, primVoid(), "abort", primString());
  addFunc(ve, run::gen17_point, primPair(), "point", primPath(), primInt());
  addFunc(ve, run::gen18_point, primPair(), "point", primPath(), primReal());
  addFunc(ve, run::gen19_precontrol, primPair(), "precontrol", primPath(), primInt());
  addFunc(ve, run::gen20_precontrol, primPair(), "precontrol", primPath(), primReal());
  addFunc(ve, run::gen21_postcontrol, primPair(), "postcontrol", primPath(), primInt());
  addFunc(ve, run::gen22_postcontrol, primPair(), "postcontrol", primPath(), primReal());
  addFunc(ve, run::gen23_dir, primPair(), "dir", primPath(), primInt());
  addFunc(ve, run::gen24_dir, primPair(), "dir", primPath(), primReal());
  addFunc(ve, run::gen25_reverse, primPath(), "reverse", primPath());
  addFunc(ve, run::gen26_subpath, primPath(), "subpath", primPath(), primInt(), primInt());
  addFunc(ve, run::gen27_subpath, primPath(), "subpath", primPath(), primReal(), primReal());
  addFunc(ve, run::gen28_length, primInt(), "length", primPath());
  addFunc(ve, run::gen29_cyclic, primBoolean(), "cyclic", primPath());
  addFunc(ve, run::gen30_straight, primBoolean(), "straight", primPath(), primInt());
  addFunc(ve, run::gen31_arclength, primReal(), "arclength", primPath());
  addFunc(ve, run::gen32_arctime, primReal(), "arctime", primPath(), primReal());
  addFunc(ve, run::gen33_dirtime, primReal(), "dirtime", primPath(), primPair());
  addFunc(ve, run::gen34_intersect, primPair(), "intersect", primPath(), primPath(), primReal());
  addFunc(ve, run::gen35_cubiclength, primReal(), "cubiclength", primTriple(), primTriple(), primTriple(), primTriple(), primReal());
  addFunc(ve, run::gen36_expi, primTriple(), "expi", primReal(), primReal());
  addFunc(ve, run::gen37_dir, primTriple(), "dir", primReal(), primReal());
  addFunc(ve, run::gen38_length, primInt(), "length", primString());
  addFunc(ve, run::gen39_find, primInt(), "find", primString(), primString(), primInt());
  addFunc(ve, run::gen40_rfind, primInt(), "rfind", primString(), primString(), primInt());
  addFunc(ve, run::gen41_reverse, primString() , "reverse", primString() );
  addFunc(ve, run::gen42_insert, primString() , "insert", primString() , primInt(), primString());
  addFunc(ve, run::gen43_substr, primString() , "substr", primString(), primInt(), primInt());
  addFunc(ve, run::gen44_erase, primString() , "erase", primString() , primInt(), primInt());
  addFunc(ve, run::gen45_gui, primVoid(), "gui", primReal());
  addFunc(ve, run::gen46_ceil, primInt(), "ceil", primReal());
  addFunc(ve, run::gen47_floor, primInt(), "floor", primReal());
  addFunc(ve, run::gen48_round, primInt(), "round", primReal());
  addFunc(ve, run::gen49_Ceil, primInt(), "Ceil", primReal());
  addFunc(ve, run::gen50_Floor, primInt(), "Floor", primReal());
  addFunc(ve, run::gen51_Round, primInt(), "Round", primReal());
  addFunc(ve, run::gen52_erf, primReal(), "erf", primReal());
  addFunc(ve, run::gen53_erfc, primReal(), "erfc", primReal());
  addFunc(ve, run::gen54_gamma, primReal(), "gamma", primReal());
  addFunc(ve, run::gen55_VERSION, primString() , "VERSION");
  addFunc(ve, run::gen56_quiet, primVoid(), "quiet", primBoolean());
  addFunc(ve, run::gen57_atexit, primVoid(), "atexit", voidFunction());
  addFunc(ve, run::gen58_atexit, voidFunction(), "atexit");
}

} // namesapce trans
