#!/usr/bin/env perl
######
# runtime.pl
# Tom Prince 2004/4/15
#
# Generates gen_run.cc from runtime.cc.
#
##### 

sub clean_type {
    for (@_) {
        s/\s//g;
    }
}

my %type_map;
sub read_types {
    my @types = split /\n/, shift;
    for (@types) {
        my ($type,$code) = 
            m|(\w*(?:\s*\*)?)
              \s*=>\s*
              (.*)
              |x;
        clean_type($type);
        $type_map{$type} = $code;
    }
}

sub asy_params {
    my @params = @_;
    for (@params) {
        my ($type, $name) = 
            m|^\s*
              (\w*(?:\s*\*)?)
              \s*
              (\w*)|xs;
        clean_type($type);
        $_ = $type_map{$type};
    }
    return @params;
}

sub c_params {
   my @params = @_;
   for (@params) {
       my ($type, $name) = 
            m|^\s*
              (\w*(?:\s*\*)?)
              \s*
              (\w*)|xs;
       $_ = "  $type $name = vm::pop<$type>(gen_theStack);\n";
   }
   reverse @params;
}

$/ = "\f\n";

open STDIN, "<runtime.in";
open STDOUT, ">genrun.cc";

$header = <>;
$types = <>;
$header = $header . <>;

print "/***** Autogenerated from runtime.in *****/\n";
print $header;
print "\nnamespace run {\n\f\n";

read_types($types);

my @builtins;
my $count = 0;
while (<>) {
  my ($comments,$type,$name,$params,$code) = 
    m|^((?:\s*//.*\n)*) # comment lines
      \s*
      (\w*(?:\s*\*)?) # return type
      \s*
      (\w*)           # function name
      \s*
      \(([\w\s*,]*)\) # paramaters
      \s*
      \{(.*)}         # body
      |xs;

  # Unique C++ function name
  $cname = "gen${count}_$name";
  
  clean_type($type);
  
  my @params = split m/,\s*/, $params;

  # Build addFunc call for asymptote
  push @builtin, "  addFunc(ve, run::" . $cname 
      . ", " . $type_map{$type}
      . ", " . '"' . $name . '"'
      . ( @params ? ", " . join(", ",asy_params(@params))
                   : "" )
      . ");\n";

  # Handle marshalling of values to/from stack
  $code =~ s/\breturn ([^;]*);/{ gen_theStack->push<$type>($1); return; }/g;
  $args = join("",c_params(@params));

  print $comments . "void $cname(vm::stack *gen_theStack)\n{\n$args$code}\n\f\n";
  
  ++$count;
}

print "} // namespace run\n";

print "\nnamespace trans {\n\n";
print "void gen_base_venv(venv &ve)\n{\n";
print @builtin;
print "}\n\n";
print "} // namesapce trans\n";
