#ifndef MENUCONTENT_HEADER_
#define MENUCONTENT_HEADER_

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

char *onOffText[2] = {"Off", "On"};
char *landSlideText[4] = {"None", "Instant", "Gravity", "Cartoon"};
char *wallTypeText[4] = {"Rubber", "Steel", "Spring", "Random"};
char *mouseText[2] = {"Custom", "Default"};
char *meteorText[4] = {"Off", "Light", "Heavy", "Lethal"};
char *lightningText[4] = {"Off", "Weak", "Energetic", "Violent"};
char *languageText[2] = {"English", "Português"};
char *colourText[2] = {"Regular", "Crispy"};
char *landTypeText[7] = { "Random", "Canyons", "Mountains", "Valleys", "Hills", "Foothills", "Plains" };
char *turnTypeText[4] = { "High+", "Low+", "Random", "Simul" };
char *skipTypeText[3] = { "Off", "Humans Dead"};

// portuege version
char *onOffText_ptbr[2] = {"Desligado", "Ligado"};
char *landSlideText_ptbr[3] = {"Nenhum", "InstantÃ¢neo", "Gravidade"};
char *wallTypeText_ptbr[4] = {"ElÃ¡stico", "AÃ§o", "Mola", "AleatÃ³rio"};
char *mouseText_ptbr[2] = {"Personalizado", "PadrÃ£o"};
char *meteorText_ptbr[4] = {"Desligado", "Fraco", "Forte", "Letal"};
char *lightningText_ptbr[4] = {"Desligado", "Fraco", "EnergÃ©tico", "Violento"};
char *languageText_ptbr[2] = {"English", "Português"};
char *colourText_ptbr[2] = {"Regular", "Crispy"};
char *landTypeText_ptbr[7] = { "aleatÃ³rio", "Canyons", "Montanhas", "Vales", "Colinas", "Morros", "Planos" };
char *turnTypeText_ptbr[4] = { "Melhores+", "Piores+", "AleatÃ³rio", "Simul" };
char *skipTypeText_ptbr[3] = { "Desligado", "Humanos Mortos", "Auto-jogo" };


// decalre variables
MENUDESC mainMenu;
 

if (global->language == LANGUAGE_ENGLISH)
{
MENUENTRY physicsOpts[5] = {
	{"Gravity", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Viscosity", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Land Slide", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 3, 1, 2, landSlideText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
        {"Land Slide Delay", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
        {"Wall Type", NULL, WHITE, &env->wallType, NULL, "%s", 0, 3, 1, 1, wallTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12}
};
MENUDESC physicsMenu = {"Physics", 5, physicsOpts, TRUE, FALSE};

MENUENTRY weatherOpts[5] = {
	{"Meteor Showers", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Lightning", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Fog (incomplete)", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
	{"Max Wind Strength", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
	{"Wind Variation", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
};
MENUDESC weatherMenu = {"Weather", 5, weatherOpts, TRUE, FALSE};

MENUENTRY graphicsOpts[8] = {
	{"Dithering", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Detailed Land", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Detailed Sky", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
        {"Colour Theme", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
        {"Screen Width", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
        {"Screen Height", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
        {"Mouse Pointer", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 52},
        {"Game Speed", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72}
};
MENUDESC graphicsMenu = {"Graphics", 8, graphicsOpts, TRUE, FALSE};

MENUENTRY financeOpts[8] = {
	{"Starting Money", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Interest Rate", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Round Win Bonus", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
	{"Damage Bounty", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
	{"Self-Damage Penalty", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
	{"Tank Destruction Bonus", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
	{"Tank Self-Destruction Penalty", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
	{"Item Sell Multiplier", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
};
MENUDESC financeMenu = {"Money", 8, financeOpts, TRUE, FALSE};


MENUENTRY mainOpts[10] = {
	{"Physics", NULL, WHITE, (double*)&physicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Weather", NULL, WHITE, (double*)&weatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Graphics", NULL, WHITE, (double*)&graphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
	{"Money", NULL, WHITE, (double*)&financeMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
	{"Tech Level", NULL, WHITE, (double*)&env->techLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight +12},
	{"Landscape", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 6, 1, LANDTYPE_HILLS, landTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
	{"Turn Order", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
	{"Skip AI-only play", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight +72},
        {"Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
        {"Language", NULL, WHITE, &global->language, NULL, "%s", 0, 1, 1, 1, languageText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}
};
// mainMenu = {"Main Menu", 10, mainOpts, TRUE, FALSE};
mainMenu.title = "Main Menu";
mainMenu.numEntries = 10;
mainMenu.entries = mainOpts;
mainMenu.quitButton = TRUE;
mainMenu.okayButton = FALSE;

}  // end of English

else   // Portuguese
{
MENUENTRY physicsOpts[5] = {
        {"Gravidade", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325,
 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 68},
        {"Viscosidade", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0,
 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 48},
        {"Deslizamento de Terra", NULL, WHITE, &env->landSlideType, NULL,
 "%s", 0, 2, 1, 2, landSlideText_ptbr, OPTION_SPECIALTYPE, FALSE,
 global->halfWidth - 3, global->halfHeight - 28},
        {"corrediça da terra atrasa", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
        {"Tipo de Parede", NULL, WHITE, &env->wallType, NULL, "%s", 0,
 3, 1, 1, wallTypeText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth -
 3, global->halfHeight + 12}
};
MENUDESC physicsMenu = {"FÃ", 5, physicsOpts, TRUE, FALSE};

MENUENTRY weatherOpts[5] = {
        {"Chuvas de Meteoro", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1,
 0, meteorText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 68},
        {"RelÃ¢mpagos", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0,
 lightningText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 48},
        {"Neblina (incompleto)", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1,
 0, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 28},
        {"Velocidade Max do Vento", NULL, WHITE, (double*)&env->windstrength,
 NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE,
 global->halfWidth - 3, global->halfHeight - 8},
        {"VariaÃ§Ã£o do Vento", NULL, WHITE, (double*)&env->windvariation,
 NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE,
 global->halfWidth - 3, global->halfHeight + 12},
};
MENUDESC weatherMenu = {"CondiÃ§Ãµes MeteorolÃ³gicas", 5, weatherOpts,
 TRUE, FALSE};

MENUENTRY graphicsOpts[8] = {
        {"Pontilhamento", NULL, WHITE, &global->ditherGradients, NULL, "%s",
 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 68},
        {"Detalhes do Terreno", NULL, WHITE, &global->detailedLandscape, NULL,
 "%s", 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE,
 global->halfWidth - 3, global->halfHeight - 48},
        {"Detalhes do CÃ©u", NULL, WHITE, &global->detailedSky, NULL, "%s", 0,
 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 28},
{"tema da cor", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},

        {"Largura da Tela", NULL, WHITE, &global->temp_screenWidth,
 NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE,
 global->halfWidth - 3, global->halfHeight + 12 },
        {"Altura da Tela", NULL, WHITE, &global->temp_screenHeight,
 NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE,
 global->halfWidth - 3, global->halfHeight + 32},
        {"Ponteiro do Mouse", NULL, WHITE, &global->os_mouse, NULL,
 "%s", 0, 1, 1, 1, mouseText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth
 - 1, global->halfHeight + 52},
        {"velocidade do jogo", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72}

};
MENUDESC graphicsMenu = {"GrÃ¡ficos", 8, graphicsOpts, TRUE, FALSE};

MENUENTRY financeOpts[8] = {
        {"Dinheiro inicial", NULL, WHITE, (double*)&global->startmoney, NULL,
 "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE,
 global->halfWidth - 3, global->halfHeight - 68},
        {"Taxa de Juros", NULL, WHITE, (double*)&global->interest, NULL,
 "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE,
 global->halfWidth - 3, global->halfHeight - 48},
        {"BÃ´nus por VitÃ³ria", NULL, WHITE,
 (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE,
 FALSE, global->halfWidth - 3, global->halfHeight - 8},
        {"BÃ´nus por Estrago", NULL, WHITE, (double*)&global->scoreHitUnit,
 NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE,
 global->halfWidth - 3, global->halfHeight + 12},
        {"Penalidade por Auto-Estrago", NULL, WHITE,
 (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE,
 FALSE, global->halfWidth - 3, global->halfHeight + 32},
        {"BÃ´nus por Tanque DestruÃ", NULL, WHITE,
 (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL,
 OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
        {"Penalidade por Auto-DestruiÃ§Ã£o", NULL, WHITE,
 (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL,
 OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
        {"Multiplicador de Item Vendido", NULL, WHITE,
 (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE,
 FALSE, global->halfWidth -3, global->halfHeight + 92},
};
MENUDESC financeMenu = {"Dinheiro", 8, financeOpts, TRUE, FALSE};

MENUENTRY mainOpts[10] = {
        {"FÃ", NULL, WHITE, (double*)&physicsMenu, NULL, NULL, 0, 0, 0,
 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 68},
        {"CondiÃ§Ãµes MeteorolÃ³gicas", NULL, WHITE, (double*)&weatherMenu,
 NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth -
 3, global->halfHeight - 48},
        {"GrÃ¡ficos", NULL, WHITE, (double*)&graphicsMenu, NULL, NULL, 0, 0,
 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 28},
        {"Dinheiro", NULL, WHITE, (double*)&financeMenu, NULL, NULL, 0, 0, 0,
 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight - 8},
        {"NÃ TecnolÃ³gico", NULL, WHITE, (double*)&env->techLevel, NULL,
 "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -
 3, global->halfHeight +12},
        {"CenÃ¡rio", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 6,
 1, LANDTYPE_HILLS, landTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
 global->halfWidth - 3, global->halfHeight + 32},
        {"Ordem de Jogadas", NULL, WHITE, (double*)&global->turntype, NULL,
 "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
 global->halfWidth - 3, global->halfHeight + 52},
        {"Pular Jogo SÃ³ com RobÃ´s", NULL, WHITE, &global->skipComputerPlay,
 NULL, "%s", 0, 2, 1, 1, skipTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
 global->halfWidth - 3, global->halfHeight +72},
        {"Som", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1,
 onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
 global->halfHeight + 92},
        {"língua", NULL, WHITE, &global->language, NULL, "%s", 0, 1, 1, 1, languageText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112}

};
// mainMenu = {"Menu Principal", 10, mainOpts, TRUE, FALSE};
mainMenu.title = "Menu Principal";
mainMenu.numEntries = 10;
mainMenu.entries = mainOpts;
mainMenu.quitButton = TRUE;
mainMenu.okayButton = FALSE;

}   // end of Portuguese

#endif

