# -*- mode: python; coding: utf-8 -*-

import os
import logging
import sys
import time
import inspect
import random
from itertools import chain


import atheist
from atheist.utils import *
import atheist.plugins

Log = atheist.Log

class Manager(object):

    __metaclass__ = Singleton

    def __init__(self, argv):
        self.abort = False
        self._task_index = 0
        self._taskcases = []
        self.tini = time.time()
        self.ntests = 0
        self.ntasks = 0
        self.ok = 0
        self.fail = 0

        self.ts = []

        self.config, self.args = atheist.parser.parse_args(argv)
#       [x for x in sys.argv[1:] if not x.startswith('--Ice')])

        # FIXME:probablemente optparse tiene soporte para esto
        if self.config.stdout and self.config.stdout_on_fail:
            logging.error("-o and -f are incompatible options")
            sys.exit(1)

        if self.config.verbosity and self.config.quiet:
            logging.error("-q and -v are incompatible options")
            sys.exit(1)

        if self.config.gen_template:
            print atheist.file_template()
            sys.exit(0)

        if not self.args and not self.config.inline:
            atheist.parser.print_help()
            sys.exit(1)

        self.config.loglevel = logging.WARNING
        if self.config.verbosity == 1:
            self.config.loglevel = logging.INFO
        elif self.config.verbosity >= 2:
            self.config.loglevel = logging.DEBUG
        if self.config.quiet:
            self.config.loglevel = logging.ERROR

        Log.setLevel(self.config.loglevel)

        self.config.timetag = "[%(asctime)s]" if self.config.timetag else ''

        formatter = atheist.LoggingFormatter(\
                self.config.timetag + '[%(levelinitial)s] %(message)s',
                atheist.LOG_DATEFORMAT)

        console = logging.StreamHandler()
        console.setFormatter(formatter)
        Log.addHandler(console)

        if self.config.log:
            filelog = logging.FileHandler(self.config.log)
            filelog.setFormatter(formatter)
            filelog.setLevel(logging.DEBUG)
            Log.addHandler(filelog)


        Log.propagate = 0
        Log.debug('Log level is %s' % logging.getLevelName(Log.level))


        self.exec_env = self.build_env()
        self.exec_env['args'] = self.config.task_args.split(',')

        compath.root = self.config.base_dir

    def build_env(self):
        symbols = [self.get_task]

        pluginpath = self.config.pluginpath + \
            [os.path.join(os.path.dirname(atheist.plugins.__file__))]

        for dname in pluginpath:
            for plugin in atheist.plugins.Loader(dname):
                Log.debug("Registering plugin %s" % plugin.__name__)
                symbols.append(plugin)

        for name,symbol in inspect.getmembers(atheist, inspect.isclass):
            if issubclass(symbol, atheist.Public):
                symbols.append(symbol)

        retval = {}
        for s in symbols:
            if inspect.isclass(s) and issubclass(s, atheist.Task):
                    s.set_mgr(self)

            retval[s.__name__] = s

        return retval


    def get_task(self, _id):
        for t in chain(self.ts):
            if t.tid == _id: return t
        Log.error("There is no task with id '%s'" % _id)
        return None


    def load(self):
        self._task_index = 0
        self._taskcases = []

        for inline in self.config.inline:
            Log.debug("inline script: %s" % inline)
            fname = os.path.join(ATHEIST_TMP, 'inline_%s.test' % os.getpid())
            fd = open(fname, 'w')
            fd.write(inline)
            fd.close()
            try:
                self.add(atheist.TestCase(fname, self))
            finally:
                print "removing %s" % fname
                os.remove(fname)

        for i in sorted([os.path.abspath(x) for x in self.args]):
            if os.path.isdir(i):
                self.process_directory(i)

            elif os.path.isfile(i):
                if i in [SETUP, TEARDOWN]: continue
                self.add(atheist.TestCase(i, self))

            else:
                try:
                    file(i).close()  # suspicious file, checking
                except IOError, e:
                    Log.critical(e)
                    sys.exit(1)


    def next(self):
        self._task_index += 1
        return self._task_index

    def add(self, taskcase):
        self._taskcases.append(taskcase)

    def process_directory(self, dname):
        for root, dirs, files in os.walk(dname):
            Log.info("Entering directory '%s'" % compath(root))
            for f in sorted([x for x in files if x.endswith(self.config.ext)]):
                if f in EXCLUDE_FILES: continue
                self.add(atheist.TestCase(os.path.join(root, f), self))
            for d in EXCLUDE_DIRS:
                if d in dirs: dirs.remove(d)


    def itertasks(self):
        return chain(*[x.tasks for x in self._taskcases])

    def itercases(self):
        return iter(self._taskcases)

    def __len__(self):
        return sum([len(s.tasks) for s in self._taskcases])

    def run(self, ob):
        def count(*args):
            self.done += 1

        self.done = 0  # completed tasks

        cases = self._taskcases[:]

        if len(cases) == 100:
            cases[0].run(ob)

        else:
            nworkers = self.config.workers
            if nworkers == 0:
                nworkers = min(100, 1+len(cases)/2)
                Log.info("Creating %s workers" % nworkers)

            pool = ThreadPool(nworkers)

            if self.config.random:
                random.seed(self.config.random)
                #FIXME:si el usuario indica 0 cambiar elegir una semilla aleatoria
                random.shuffle(cases)

            for tc in cases:
                pool.add(tc.run, [ob], callback=count)

            #pool.join()
            while not self.abort:
                if self.done == len(cases): break
                time.sleep(0.5)

            pool.join(True, True)

        self.calculate()


    def calculate(self):
        self.ntasks += len([x for x in self.itertasks()])
        tests = [x for x in self.itertasks() if x.check]
        self.ntests += len(tests)
        self.ok    += len([x for x in tests if x.result == OK])
        self.fail = self.ntests - self.ok

    def str_stats(self):
        delta = time.time() - self.tini
        if delta > 60:
            t = "%s.%s" % (time.strftime("%H:%M:%S", time.gmtime(delta)),
                           ("%.2f" % (delta % 1.0))[2:])
        else:
            t = "%.2fs" % delta

        if self.ok == self.ntests:
            return (BOLD + IGREEN + " ALL OK!! " + NORM + " - %s - %s - %s " ) % (
                t, count(self.ntasks, 'task'), count(self.ntests, 'test'))

        return "%s - %s%s%s/%s" % \
            (t,
             HIGH, self.ok, NORM,
             count(self.ntests, 'test'))

    def ALL(self):
        return self.ok == self.ntests

