#!/usr/bin/python -u
# -*- mode: python; coding: utf-8 -*-

from __future__ import with_statement

import sys
import threading
import os
import logging

import Ice
cwd = os.path.dirname(__file__)
Ice.loadSlice('-I%s --all %s/atheist.ice' % (Ice.getSliceDir(), cwd))

import Atheist as ath
from atheist.manager import Manager

logging.getLogger().setLevel(logging.DEBUG)


def get_proxies(adapter, cast, servants):
    proxies = [adapter.addWithUUID(x) for x in servants]
    return [cast.uncheckedCast(x) for x in proxies]


class TaskCaseI(ath.TaskCase):

    def __init__(self, mgr, tc):
        self.mgr = mgr
        self.tc = tc
        self.lock = threading.Lock()

    # from TaskCase interface
    def run(self, current=None):
        if self.lock.locked():
            self.mgr.statusOb.updateTaskCases(
                {self.tc.fname: ath.Status.RUNNING})
            return

        with self.lock:
            self.mgr.statusOb.updateTaskCases(
                {self.tc.fname: ath.Status.RUNNING})

            self.tc.run()
            self.mgr.statusOb.updateTasks(
                dict([("%s:%s" % (t.fname, t.name),
                       ath.Status(t.result)) for t in self.tc.tasks]))

            self.mgr.statusOb.updateTaskCases(
                {self.tc.fname: ath.Status(self.tc.status())})

    # from TaskCase interface
    def getConfig(self, current=None):
        retval = {}
        for task in self.tc.tasks:
            config = ath.TaskConfig(indx=task.indx)
            for name in [x for x in dir(config)
                     if x in atheist.task_attrs.keys()]:
                setattr(config, name, getattr(task, name))
            retval[str(task.indx)] = config

        return retval

    # from TaskCase interface
    def getStatus(self, current=None):
        raise NotImplementedError


class ManagerI(ath.Manager):

    def __init__(self, argv, adap):
        self.mgr = Manager(argv)
        self.adap = adap
        self.statusOb = None
        self.outOb = None
        self.logOb = None
        self.servants = [] # the task cases
        self.proxies = []
        self.lock = threading.Lock()

    def refresh(self):
        # FIXME: Se deben eliminar los proxies de los cases que ya no
        # existen y añadir solo los nuevos

        for prx in self.proxies:
            self.adap.remove(prx.ice_getIdentity())

        self.mgr.load()
        self.servants = [TaskCaseI(self,x) for x in self.mgr.itercases()]
        self.proxies = get_proxies(self.adap, ath.TaskCasePrx,
                                   self.servants)

        print "servants:", len(self.servants)

    # from Manager interface
    def getTaskCases(self, current=None):
        return self.proxies

    # from Manager interface
    def runAll(self, current=None):
        if self.lock.locked():
            print 'runAll: Manager is already running .............'
            return

        with self.lock:
            self.refresh()
            self.statusOb.updateManager(ath.Status.RUNNING)
            for tc in self.servants:
                tc.run()
            self.statusOb.updateManager(ath.Status.UNKNOWN)

    # from Manager interface
    def attachStatusOb(self, ob, current=None):
        self.statusOb = ob

    # from Manager interface
    def attachOutOb(self, ob, taskIds, current=None):
        self.outOb = ob

    # from Manager interface
    def attachLogOb(self, ob, taskIds, current=None):
        self.logOb = ob


class server(Ice.Application):

    def run(self, argv):
        self.shutdownOnInterrupt()
        ic = self.communicator()

        adapter = self.communicator().createObjectAdapter("Manager.Adapter")
        oid = ic.getProperties().getProperty("Manager.InstanceName")
        oid = ic.stringToIdentity(oid)
        proxy = adapter.add(ManagerI(argv, adapter), oid)
        adapter.activate()

        logging.debug("Manager at '%s'" % proxy)

        self.communicator().waitForShutdown()
        return 0


if __name__ == "__main__":
    sys.exit(server().main(sys.argv))
