# -*- mode: python; coding: utf-8 -*-

import os, re

VERSION = '0.20101024'

SETUP    = '_setup.test'
TEARDOWN = '_teardown.test'

# FIXME: fichero de configuración .atheist
EXCLUDE = ['.svn', '.hg', SETUP, TEARDOWN]

INCLUDE_RE = re.compile(r"""include\("([\./\w\d]+)"\)\s*$""")


#task status
FAIL =    False   # Failed
OK =      True    # Success
NOEXEC =  2       # Never executed
ERROR =   3       # The task itself produced an unexpected error
UNKNOWN = 4
TODO    = 5
mild_FAIL = 6

STR_STATUS = {\
    FAIL:      'FAIL',
    OK:        ' OK ',
    NOEXEC:    ' -- ',
    ERROR:     ' !! ',
    UNKNOWN:   ' ?? ',
    TODO:      'ToDo',
    mild_FAIL: 'fail'
    }

ATHEIST_BASE = os.path.join(os.environ['HOME'], '.atheist')
ATHEIST_TMP =  '/tmp/atheist'
ATHEIST_CFG =  os.path.join(ATHEIST_BASE, 'config')
ATHEIST_LOG =  os.path.join(ATHEIST_BASE, 'log')
ATHEIST_EXT = '.test'

USAGE = '''atheist [options] [file|directory]

atheist is a testing tool.
This is version %s, Copyright (C) 2009,2010 David Villa Alises
atheist comes with ABSOLUTELY NO WARRANTY; This is free software, and you are
welcome to redistribute it under certain conditions; See COPYING for details.''' % VERSION
