# -*- coding:utf-8 -*-

import sys
import doctest
import atheist

class DocTest(atheist.Plugin, atheist.Task):
    acro = 'DocT'
    allows = ['cwd', 'delay', 'desc', 'must_fail', 'template', 'tid']

    def __init__(self, module_name, **kargs):
        self.module_name = module_name
        self.check = True

        atheist.Task.__init__(self, **kargs)
        self.wrap_outs = True


    def exec_task(self):
        self.log.debug("runing doctest")

        if self.cwd:
            sys.path.append(self.cwd)

        try:
            module = __import__(self.module_name, fromlist=self.module_name.split('.')[-1])
            self.log.debug("%s" % module)
            self.result = (doctest.testmod(module)[0] == 0)
            del module

        except ImportError, e:
            atheist.Log.warning(e)
            self.result = atheist.ERROR


    def str_param(self):
        return self.module_name
