#!/bin/sh

set -e

UPSTREAM_VERSION=`echo $2 | sed -n 's/^\([0-9]\)\.0/\1/p'`
DEBIAN_VERSION=`dpkg-parsechangelog | sed -n 's/^Version: \(.*\)-.*/\1/p'`
TAG=javax.inject-tck-$UPSTREAM_VERSION
DIR=atinject-jsr330
TAR=../atinject-jsr330_$DEBIAN_VERSION.orig.tar.xz

svn export http://atinject.googlecode.com/svn/tags/$TAG $DIR
tar -c -J -f $TAR --exclude '*.jar' --exclude '*.iml' --exclude '*.ipr' --exclude 'javadoc/*' $DIR
rm -Rf $3 $DIR

#url="http://atinject.googlecode.com/files/javax.inject.zip"
#package=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
#version=`dpkg-parsechangelog | sed -n 's/^Version: \(.*\)-.*/\1/p'`
#tarball="javax.inject.zip"
#TAR=${package}_${version}.orig.tar.gz
#DIR=${package}-${version}.orig
#
#wget $url
#unzip $tarball -d $DIR
#unzip $DIR/javax.inject-src.zip -d $DIR
#
#GZIP=--best tar --numeric --group 0 --owner 0 -c -v -z -f $TAR \
#    --exclude '*.zip' --exclude '*.jar' $DIR
#
#rm -rf $tarball $DIR
