#ifndef ATL_sGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,240,320,400,480,960,1200,1440,1680,1760,1840,1920
 * N : 25,240,320,400,480,960,1200,1440,1680,1760,1840,1920
 * NB : 2,12,12,12,28,30,30,40,20,50,50,320
 */
#define ATL_sGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 132) (nb_) = 2; \
   else if ((n_) < 440) (nb_) = 12; \
   else if ((n_) < 720) (nb_) = 28; \
   else if ((n_) < 1320) (nb_) = 30; \
   else if ((n_) < 1560) (nb_) = 40; \
   else if ((n_) < 1720) (nb_) = 20; \
   else if ((n_) < 1880) (nb_) = 50; \
   else (nb_) = 320; \
}


#endif    /* end ifndef ATL_sGetNB_geqrf */
